package cdm.event.common.validation;

import cdm.event.common.CorporateAction;
import com.google.common.collect.Lists;
import com.rosetta.model.lib.expression.ComparisonResult;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.validation.ValidationResult;
import com.rosetta.model.lib.validation.ValidationResult.ValidationType;
import com.rosetta.model.lib.validation.Validator;

import static com.google.common.base.Strings.isNullOrEmpty;
import static com.rosetta.model.lib.validation.ValidationResult.failure;
import static com.rosetta.model.lib.validation.ValidationResult.success;
import static java.util.stream.Collectors.joining;

public class CorporateActionTypeFormatValidator implements Validator<CorporateAction> {

	@Override
	public ValidationResult<CorporateAction> validate(RosettaPath path, CorporateAction o) {
		String error = 
			Lists.<ComparisonResult>newArrayList(
			).stream().filter(res -> !res.get()).map(res -> res.getError()).collect(joining("; "));
		
		if (!isNullOrEmpty(error)) {
			return failure("CorporateAction", ValidationType.TYPE_FORMAT, "CorporateAction", path, "", error);
		}
		return success("CorporateAction", ValidationType.TYPE_FORMAT, "CorporateAction", path, "");
	}

}
