package cdm.event.common.functions;

import cdm.base.math.CompareOp;
import cdm.event.common.Trade;
import cdm.event.common.TradeState;
import cdm.product.template.TradableProduct;
import cdm.product.template.TradeLot;
import cdm.product.template.functions.CompareTradeLotToAmount;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.expression.CardinalityOperator;
import com.rosetta.model.lib.functions.RosettaFunction;
import com.rosetta.model.lib.mapper.MapperC;
import com.rosetta.model.lib.mapper.MapperS;
import java.math.BigDecimal;
import java.util.List;
import javax.inject.Inject;

import static com.rosetta.model.lib.expression.ExpressionOperators.*;

@ImplementedBy(QuantityDecreasedToZero.QuantityDecreasedToZeroDefault.class)
public abstract class QuantityDecreasedToZero implements RosettaFunction {
	
	// RosettaFunction dependencies
	//
	@Inject protected CompareTradeLotToAmount compareTradeLotToAmount;
	@Inject protected CompareTradeStatesToAmount compareTradeStatesToAmount;

	/**
	* @param before 
	* @param after 
	* @return result 
	*/
	public Boolean evaluate(List<? extends TradeState> before, List<? extends TradeState> after) {
		Boolean result = doEvaluate(before, after);
		
		return result;
	}

	protected abstract Boolean doEvaluate(List<? extends TradeState> before, List<? extends TradeState> after);

	public static class QuantityDecreasedToZeroDefault extends QuantityDecreasedToZero {
		@Override
		protected Boolean doEvaluate(List<? extends TradeState> before, List<? extends TradeState> after) {
			Boolean result = null;
			return assignOutput(result, before, after);
		}
		
		protected Boolean assignOutput(Boolean result, List<? extends TradeState> before, List<? extends TradeState> after) {
			result = areEqual(MapperS.of(compareTradeLotToAmount.evaluate(MapperS.of(MapperC.<TradeState>of(before).<Trade>map("getTrade", tradeState -> tradeState.getTrade()).<TradableProduct>map("getTradableProduct", trade -> trade.getTradableProduct()).<TradeLot>mapC("getTradeLot", tradableProduct -> tradableProduct.getTradeLot()).get()).get(), MapperS.of(CompareOp.GREATER_THAN_OR_EQUALS).get(), MapperS.of(new BigDecimal("0.0")).get())), MapperS.of(Boolean.valueOf(true)), CardinalityOperator.All).and(areEqual(MapperS.of(compareTradeStatesToAmount.evaluate(MapperC.<TradeState>of(after).getMulti(), MapperS.of(CompareOp.EQUALS).get(), MapperS.of(new BigDecimal("0.0")).get())), MapperS.of(Boolean.valueOf(true)), CardinalityOperator.All)).get();
			
			return result;
		}
	}
}
