package cdm.event.common.functions;

import cdm.base.datetime.AdjustableOrRelativeDate;
import cdm.event.common.BusinessEvent;
import cdm.product.collateral.Collateral;
import cdm.product.template.EconomicTerms;
import cdm.product.template.Payout;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.expression.CardinalityOperator;
import com.rosetta.model.lib.functions.IQualifyFunctionExtension;
import com.rosetta.model.lib.functions.RosettaFunction;
import com.rosetta.model.lib.mapper.Mapper;
import com.rosetta.model.lib.mapper.MapperS;
import javax.inject.Inject;

import static com.rosetta.model.lib.expression.ExpressionOperators.*;

@ImplementedBy(Qualify_Substitution.Qualify_SubstitutionDefault.class)
public abstract class Qualify_Substitution implements RosettaFunction,IQualifyFunctionExtension<BusinessEvent> {
	
	// RosettaFunction dependencies
	//
	@Inject protected ExtractBeforeEconomicTerms extractBeforeEconomicTerms;
	@Inject protected ExtractOpenEconomicTerms extractOpenEconomicTerms;

	/**
	* @param businessEvent 
	* @return is_event 
	*/
	@Override
	public Boolean evaluate(BusinessEvent businessEvent) {
		Boolean is_event = doEvaluate(businessEvent);
		
		return is_event;
	}

	protected abstract Boolean doEvaluate(BusinessEvent businessEvent);

	protected abstract Mapper<? extends EconomicTerms> beforeEconomicterms(BusinessEvent businessEvent);

	protected abstract Mapper<? extends EconomicTerms> openEconomicTerms(BusinessEvent businessEvent);

	public static class Qualify_SubstitutionDefault extends Qualify_Substitution {
		@Override
		protected Boolean doEvaluate(BusinessEvent businessEvent) {
			Boolean is_event = null;
			return assignOutput(is_event, businessEvent);
		}
		
		protected Boolean assignOutput(Boolean is_event, BusinessEvent businessEvent) {
			is_event = exists(MapperS.of(beforeEconomicterms(businessEvent).get())).and(exists(MapperS.of(openEconomicTerms(businessEvent).get()))).and(notEqual(MapperS.of(openEconomicTerms(businessEvent).get()).<Payout>map("getPayout", economicTerms -> economicTerms.getPayout()), MapperS.of(beforeEconomicterms(businessEvent).get()).<Payout>map("getPayout", economicTerms -> economicTerms.getPayout()), CardinalityOperator.Any)).and(notEqual(MapperS.of(openEconomicTerms(businessEvent).get()).<Collateral>map("getCollateral", economicTerms -> economicTerms.getCollateral()), MapperS.of(beforeEconomicterms(businessEvent).get()).<Collateral>map("getCollateral", economicTerms -> economicTerms.getCollateral()), CardinalityOperator.Any)).and(areEqual(MapperS.of(openEconomicTerms(businessEvent).get()).<AdjustableOrRelativeDate>map("getEffectiveDate", economicTerms -> economicTerms.getEffectiveDate()), MapperS.of(beforeEconomicterms(businessEvent).get()).<AdjustableOrRelativeDate>map("getTerminationDate", economicTerms -> economicTerms.getTerminationDate()), CardinalityOperator.All)).and(areEqual(MapperS.of(openEconomicTerms(businessEvent).get()).<AdjustableOrRelativeDate>map("getTerminationDate", economicTerms -> economicTerms.getTerminationDate()), MapperS.of(beforeEconomicterms(businessEvent).get()).<AdjustableOrRelativeDate>map("getTerminationDate", economicTerms -> economicTerms.getTerminationDate()), CardinalityOperator.All)).get();
			
			return is_event;
		}
		
		@Override
		protected Mapper<? extends EconomicTerms> beforeEconomicterms(BusinessEvent businessEvent) {
			return MapperS.of(extractBeforeEconomicTerms.evaluate(MapperS.of(businessEvent).get()));
		}
		
		@Override
		protected Mapper<? extends EconomicTerms> openEconomicTerms(BusinessEvent businessEvent) {
			return MapperS.of(extractOpenEconomicTerms.evaluate(MapperS.of(businessEvent).get()));
		}
	}
		
		@Override
		public String getNamePrefix() {
			return "Qualify";
		}
}
