package cdm.event.common.functions;

import cdm.base.staticdata.identifier.IdentifiedList;
import cdm.base.staticdata.party.Counterparty;
import cdm.base.staticdata.party.Party;
import cdm.base.staticdata.party.metafields.ReferenceWithMetaParty;
import cdm.event.common.BusinessEvent;
import cdm.event.common.ExecutionDetails;
import cdm.event.common.Instruction;
import cdm.event.common.PrimitiveInstruction;
import cdm.event.common.SplitInstruction;
import cdm.event.common.Trade;
import cdm.event.common.TradeState;
import cdm.event.common.metafields.ReferenceWithMetaTradeState;
import cdm.product.template.TradableProduct;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.expression.CardinalityOperator;
import com.rosetta.model.lib.functions.IQualifyFunctionExtension;
import com.rosetta.model.lib.functions.RosettaFunction;
import com.rosetta.model.lib.mapper.Mapper;
import com.rosetta.model.lib.mapper.MapperC;
import com.rosetta.model.lib.mapper.MapperS;
import java.util.Arrays;
import javax.inject.Inject;

import static com.rosetta.model.lib.expression.ExpressionOperators.*;

@ImplementedBy(Qualify_Shaping.Qualify_ShapingDefault.class)
public abstract class Qualify_Shaping implements RosettaFunction,IQualifyFunctionExtension<BusinessEvent> {
	
	// RosettaFunction dependencies
	//
	@Inject protected FilterClosedTradeStates filterClosedTradeStates;
	@Inject protected FilterOpenTradeStates filterOpenTradeStates;
	@Inject protected TradeNoExecutionDetails tradeNoExecutionDetails;

	/**
	* @param businessEvent 
	* @return is_event 
	*/
	@Override
	public Boolean evaluate(BusinessEvent businessEvent) {
		Boolean is_event = doEvaluate(businessEvent);
		
		return is_event;
	}

	protected abstract Boolean doEvaluate(BusinessEvent businessEvent);

	protected abstract Mapper<? extends TradeState> beforeTradeState(BusinessEvent businessEvent);

	protected abstract Mapper<? extends TradeState> closedTradeState(BusinessEvent businessEvent);

	protected abstract Mapper<? extends TradeState> openTradeStates(BusinessEvent businessEvent);

	protected abstract Mapper<? extends IdentifiedList> packageRef(BusinessEvent businessEvent);

	protected abstract Mapper<? extends Trade> openTradeNoExecutionDetails(BusinessEvent businessEvent);

	public static class Qualify_ShapingDefault extends Qualify_Shaping {
		@Override
		protected Boolean doEvaluate(BusinessEvent businessEvent) {
			Boolean is_event = null;
			return assignOutput(is_event, businessEvent);
		}
		
		protected Boolean assignOutput(Boolean is_event, BusinessEvent businessEvent) {
			is_event = exists(MapperS.of(beforeTradeState(businessEvent).get())).and(exists(MapperS.of(closedTradeState(businessEvent).get()))).and(greaterThan(MapperS.of(MapperC.<TradeState>of(openTradeStates(businessEvent).getMulti()).resultCount()), MapperS.of(Integer.valueOf(1)), CardinalityOperator.All)).and(onlyExists(Arrays.asList(MapperS.of(businessEvent).<Instruction>mapC("getInstruction", eventInstruction -> eventInstruction.getInstruction()).<PrimitiveInstruction>map("getPrimitiveInstruction", instruction -> instruction.getPrimitiveInstruction()).<SplitInstruction>map("getSplit", primitiveInstruction -> primitiveInstruction.getSplit())))).and(areEqual(MapperC.<TradeState>of(openTradeStates(businessEvent).getMulti())
				.mapItem(item -> (MapperS<Boolean>)areEqual(item.<Trade>map("getTrade", tradeState -> tradeState.getTrade()).<TradableProduct>map("getTradableProduct", trade -> trade.getTradableProduct()).<Counterparty>mapC("getCounterparty", tradableProduct -> tradableProduct.getCounterparty()).<ReferenceWithMetaParty>map("getPartyReference", counterparty -> counterparty.getPartyReference()).<Party>map("getValue", _f->_f.getValue()), MapperS.of(beforeTradeState(businessEvent).get()).<Trade>map("getTrade", tradeState -> tradeState.getTrade()).<TradableProduct>map("getTradableProduct", trade -> trade.getTradableProduct()).<Counterparty>mapC("getCounterparty", tradableProduct -> tradableProduct.getCounterparty()).<ReferenceWithMetaParty>map("getPartyReference", counterparty -> counterparty.getPartyReference()).<Party>map("getValue", _f->_f.getValue()), CardinalityOperator.All).asMapper()), MapperS.of(Boolean.valueOf(true)), CardinalityOperator.All)).and(areEqual(MapperS.of(MapperC.<IdentifiedList>of(packageRef(businessEvent).getMulti()).resultCount()), MapperS.of(MapperC.<Trade>of(openTradeNoExecutionDetails(businessEvent).getMulti()).resultCount()), CardinalityOperator.All)).and(areEqual(MapperS.of(distinct(MapperC.<IdentifiedList>of(packageRef(businessEvent).getMulti())).resultCount()), MapperS.of(Integer.valueOf(1)), CardinalityOperator.All)).get();
			
			return is_event;
		}
		
		@Override
		protected Mapper<? extends TradeState> beforeTradeState(BusinessEvent businessEvent) {
			return MapperS.of(MapperS.of(businessEvent).<Instruction>mapC("getInstruction", eventInstruction -> eventInstruction.getInstruction()).<ReferenceWithMetaTradeState>map("getBefore", instruction -> instruction.getBefore()).<TradeState>map("getValue", _f->_f.getValue()).get());
		}
		
		@Override
		protected Mapper<? extends TradeState> closedTradeState(BusinessEvent businessEvent) {
			return MapperS.of(MapperC.<TradeState>of(filterClosedTradeStates.evaluate(MapperS.of(businessEvent).<TradeState>mapC("getAfter", _businessEvent -> _businessEvent.getAfter()).getMulti())).get());
		}
		
		@Override
		protected Mapper<? extends TradeState> openTradeStates(BusinessEvent businessEvent) {
			return MapperC.<TradeState>of(filterOpenTradeStates.evaluate(MapperS.of(businessEvent).<TradeState>mapC("getAfter", _businessEvent -> _businessEvent.getAfter()).getMulti()));
		}
		
		@Override
		protected Mapper<? extends IdentifiedList> packageRef(BusinessEvent businessEvent) {
			return MapperC.<TradeState>of(openTradeStates(businessEvent).getMulti()).<Trade>map("getTrade", tradeState -> tradeState.getTrade()).<ExecutionDetails>map("getExecutionDetails", trade -> trade.getExecutionDetails()).<IdentifiedList>map("getPackageReference", executionDetails -> executionDetails.getPackageReference());
		}
		
		@Override
		protected Mapper<? extends Trade> openTradeNoExecutionDetails(BusinessEvent businessEvent) {
			return MapperC.<TradeState>of(openTradeStates(businessEvent).getMulti())
				.mapItem(item -> (MapperS<Trade>)MapperS.of(tradeNoExecutionDetails.evaluate(item.<Trade>map("getTrade", tradeState -> tradeState.getTrade()).get())));
		}
	}
		
		@Override
		public String getNamePrefix() {
			return "Qualify";
		}
}
