package cdm.base.staticdata.identifier.validation;

import cdm.base.staticdata.identifier.LocationIdentifier;
import com.google.common.collect.Lists;
import com.rosetta.model.lib.expression.ComparisonResult;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.validation.ValidationResult;
import com.rosetta.model.lib.validation.ValidationResult.ValidationType;
import com.rosetta.model.lib.validation.Validator;

import static com.google.common.base.Strings.isNullOrEmpty;
import static com.rosetta.model.lib.validation.ValidationResult.failure;
import static com.rosetta.model.lib.validation.ValidationResult.success;
import static java.util.stream.Collectors.joining;

public class LocationIdentifierTypeFormatValidator implements Validator<LocationIdentifier> {

	@Override
	public ValidationResult<LocationIdentifier> validate(RosettaPath path, LocationIdentifier o) {
		String error = 
			Lists.<ComparisonResult>newArrayList(
			).stream().filter(res -> !res.get()).map(res -> res.getError()).collect(joining("; "));
		
		if (!isNullOrEmpty(error)) {
			return failure("LocationIdentifier", ValidationType.TYPE_FORMAT, "LocationIdentifier", path, "", error);
		}
		return success("LocationIdentifier", ValidationType.TYPE_FORMAT, "LocationIdentifier", path, "");
	}

}
