package cdm.base.staticdata.asset.credit.validation;

import cdm.base.staticdata.asset.credit.NotDomesticCurrency;
import com.google.common.collect.Lists;
import com.rosetta.model.lib.expression.ComparisonResult;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.validation.ValidationResult;
import com.rosetta.model.lib.validation.ValidationResult.ValidationType;
import com.rosetta.model.lib.validation.Validator;
import com.rosetta.model.metafields.FieldWithMetaString;

import static com.google.common.base.Strings.isNullOrEmpty;
import static com.rosetta.model.lib.expression.ExpressionOperators.checkCardinality;
import static com.rosetta.model.lib.validation.ValidationResult.failure;
import static com.rosetta.model.lib.validation.ValidationResult.success;
import static java.util.stream.Collectors.joining;

public class NotDomesticCurrencyValidator implements Validator<NotDomesticCurrency> {

	@Override
	public ValidationResult<NotDomesticCurrency> validate(RosettaPath path, NotDomesticCurrency o) {
		/* Casting is required to ensure types are output to ensure recompilation in Rosetta */
		String error = 
			Lists.<ComparisonResult>newArrayList(
				checkCardinality("applicable", (Boolean) o.getApplicable() != null ? 1 : 0, 1, 1), 
				checkCardinality("currency", (FieldWithMetaString) o.getCurrency() != null ? 1 : 0, 0, 1)
			).stream().filter(res -> !res.get()).map(res -> res.getError()).collect(joining("; "));
		
		if (!isNullOrEmpty(error)) {
			return failure("NotDomesticCurrency", ValidationType.CARDINALITY, "NotDomesticCurrency", path, "", error);
		}
		return success("NotDomesticCurrency", ValidationType.CARDINALITY, "NotDomesticCurrency", path, "");
	}

}
