package cdm.base.staticdata.asset.common.validation;

import cdm.base.staticdata.asset.common.CollateralTaxonomyValue;
import com.google.common.collect.Lists;
import com.rosetta.model.lib.expression.ComparisonResult;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.validation.ValidationResult;
import com.rosetta.model.lib.validation.ValidationResult.ValidationType;
import com.rosetta.model.lib.validation.Validator;

import static com.google.common.base.Strings.isNullOrEmpty;
import static com.rosetta.model.lib.validation.ValidationResult.failure;
import static com.rosetta.model.lib.validation.ValidationResult.success;
import static java.util.stream.Collectors.joining;

public class CollateralTaxonomyValueTypeFormatValidator implements Validator<CollateralTaxonomyValue> {

	@Override
	public ValidationResult<CollateralTaxonomyValue> validate(RosettaPath path, CollateralTaxonomyValue o) {
		String error = 
			Lists.<ComparisonResult>newArrayList(
			).stream().filter(res -> !res.get()).map(res -> res.getError()).collect(joining("; "));
		
		if (!isNullOrEmpty(error)) {
			return failure("CollateralTaxonomyValue", ValidationType.TYPE_FORMAT, "CollateralTaxonomyValue", path, "", error);
		}
		return success("CollateralTaxonomyValue", ValidationType.TYPE_FORMAT, "CollateralTaxonomyValue", path, "");
	}

}
