package cdm.base.math.validation;

import cdm.base.math.MoneyRange;
import com.google.common.collect.Lists;
import com.rosetta.model.lib.expression.ComparisonResult;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.validation.ValidationResult;
import com.rosetta.model.lib.validation.ValidationResult.ValidationType;
import com.rosetta.model.lib.validation.Validator;

import static com.google.common.base.Strings.isNullOrEmpty;
import static com.rosetta.model.lib.validation.ValidationResult.failure;
import static com.rosetta.model.lib.validation.ValidationResult.success;
import static java.util.stream.Collectors.joining;

public class MoneyRangeTypeFormatValidator implements Validator<MoneyRange> {

	@Override
	public ValidationResult<MoneyRange> validate(RosettaPath path, MoneyRange o) {
		String error = 
			Lists.<ComparisonResult>newArrayList(
			).stream().filter(res -> !res.get()).map(res -> res.getError()).collect(joining("; "));
		
		if (!isNullOrEmpty(error)) {
			return failure("MoneyRange", ValidationType.TYPE_FORMAT, "MoneyRange", path, "", error);
		}
		return success("MoneyRange", ValidationType.TYPE_FORMAT, "MoneyRange", path, "");
	}

}
