package cdm.base.math.validation;

import cdm.base.math.MoneyBound;
import com.google.common.collect.Lists;
import com.rosetta.model.lib.expression.ComparisonResult;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.validation.ValidationResult;
import com.rosetta.model.lib.validation.ValidationResult.ValidationType;
import com.rosetta.model.lib.validation.Validator;

import static com.google.common.base.Strings.isNullOrEmpty;
import static com.rosetta.model.lib.validation.ValidationResult.failure;
import static com.rosetta.model.lib.validation.ValidationResult.success;
import static java.util.stream.Collectors.joining;

public class MoneyBoundTypeFormatValidator implements Validator<MoneyBound> {

	@Override
	public ValidationResult<MoneyBound> validate(RosettaPath path, MoneyBound o) {
		String error = 
			Lists.<ComparisonResult>newArrayList(
			).stream().filter(res -> !res.get()).map(res -> res.getError()).collect(joining("; "));
		
		if (!isNullOrEmpty(error)) {
			return failure("MoneyBound", ValidationType.TYPE_FORMAT, "MoneyBound", path, "", error);
		}
		return success("MoneyBound", ValidationType.TYPE_FORMAT, "MoneyBound", path, "");
	}

}
