package cdm.base.math.validation;

import cdm.base.math.Measure;
import com.google.common.collect.Lists;
import com.rosetta.model.lib.expression.ComparisonResult;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.validation.ValidationResult;
import com.rosetta.model.lib.validation.ValidationResult.ValidationType;
import com.rosetta.model.lib.validation.Validator;

import static com.google.common.base.Strings.isNullOrEmpty;
import static com.rosetta.model.lib.validation.ValidationResult.failure;
import static com.rosetta.model.lib.validation.ValidationResult.success;
import static java.util.stream.Collectors.joining;

public class MeasureTypeFormatValidator implements Validator<Measure> {

	@Override
	public ValidationResult<Measure> validate(RosettaPath path, Measure o) {
		String error = 
			Lists.<ComparisonResult>newArrayList(
			).stream().filter(res -> !res.get()).map(res -> res.getError()).collect(joining("; "));
		
		if (!isNullOrEmpty(error)) {
			return failure("Measure", ValidationType.TYPE_FORMAT, "Measure", path, "", error);
		}
		return success("Measure", ValidationType.TYPE_FORMAT, "Measure", path, "");
	}

}
