package cdm.base.datetime.functions;

import cdm.base.datetime.AdjustableDate;
import cdm.base.datetime.AdjustableOrAdjustedOrRelativeDate;
import cdm.base.datetime.AdjustableOrAdjustedOrRelativeDate.AdjustableOrAdjustedOrRelativeDateBuilder;
import cdm.base.datetime.AdjustableOrRelativeDate;
import cdm.base.datetime.AdjustedRelativeDateOffset;
import cdm.base.datetime.BusinessCenters;
import cdm.base.datetime.BusinessDayAdjustments;
import cdm.base.datetime.BusinessDayConventionEnum;
import cdm.base.datetime.DayTypeEnum;
import cdm.base.datetime.PeriodEnum;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.functions.ModelObjectValidator;
import com.rosetta.model.lib.functions.RosettaFunction;
import com.rosetta.model.lib.mapper.Mapper;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.mapper.MapperUtils;
import com.rosetta.model.lib.records.Date;
import com.rosetta.model.metafields.FieldWithMetaDate;
import com.rosetta.model.metafields.ReferenceWithMetaDate;
import java.util.Optional;
import javax.inject.Inject;

import static com.rosetta.model.lib.expression.ExpressionOperators.*;

@ImplementedBy(ConvertToAdjustableOrAdjustedOrRelativeDate.ConvertToAdjustableOrAdjustedOrRelativeDateDefault.class)
public abstract class ConvertToAdjustableOrAdjustedOrRelativeDate implements RosettaFunction {
	
	@Inject protected ModelObjectValidator objectValidator;

	/**
	* @param adjustableOrRelativeDate 
	* @return adjustableOrAdjustedOrRelativeDate 
	*/
	public AdjustableOrAdjustedOrRelativeDate evaluate(AdjustableOrRelativeDate adjustableOrRelativeDate) {
		AdjustableOrAdjustedOrRelativeDate.AdjustableOrAdjustedOrRelativeDateBuilder adjustableOrAdjustedOrRelativeDateBuilder = doEvaluate(adjustableOrRelativeDate);
		
		final AdjustableOrAdjustedOrRelativeDate adjustableOrAdjustedOrRelativeDate;
		if (adjustableOrAdjustedOrRelativeDateBuilder == null) {
			adjustableOrAdjustedOrRelativeDate = null;
		} else {
			adjustableOrAdjustedOrRelativeDate = adjustableOrAdjustedOrRelativeDateBuilder.build();
			objectValidator.validate(AdjustableOrAdjustedOrRelativeDate.class, adjustableOrAdjustedOrRelativeDate);
		}
		
		return adjustableOrAdjustedOrRelativeDate;
	}

	protected abstract AdjustableOrAdjustedOrRelativeDate.AdjustableOrAdjustedOrRelativeDateBuilder doEvaluate(AdjustableOrRelativeDate adjustableOrRelativeDate);

	protected abstract Mapper<? extends AdjustedRelativeDateOffset> relativeDate(AdjustableOrRelativeDate adjustableOrRelativeDate);

	public static class ConvertToAdjustableOrAdjustedOrRelativeDateDefault extends ConvertToAdjustableOrAdjustedOrRelativeDate {
		@Override
		protected AdjustableOrAdjustedOrRelativeDate.AdjustableOrAdjustedOrRelativeDateBuilder doEvaluate(AdjustableOrRelativeDate adjustableOrRelativeDate) {
			AdjustableOrAdjustedOrRelativeDate.AdjustableOrAdjustedOrRelativeDateBuilder adjustableOrAdjustedOrRelativeDate = AdjustableOrAdjustedOrRelativeDate.builder();
			return assignOutput(adjustableOrAdjustedOrRelativeDate, adjustableOrRelativeDate);
		}
		
		protected AdjustableOrAdjustedOrRelativeDate.AdjustableOrAdjustedOrRelativeDateBuilder assignOutput(AdjustableOrAdjustedOrRelativeDate.AdjustableOrAdjustedOrRelativeDateBuilder adjustableOrAdjustedOrRelativeDate, AdjustableOrRelativeDate adjustableOrRelativeDate) {
			adjustableOrAdjustedOrRelativeDate
				.setAdjustedDateValue(MapperS.of(adjustableOrRelativeDate).<AdjustableDate>map("getAdjustableDate", _adjustableOrRelativeDate -> _adjustableOrRelativeDate.getAdjustableDate()).<FieldWithMetaDate>map("getAdjustedDate", adjustableDate -> adjustableDate.getAdjustedDate()).<Date>map("getValue", _f->_f.getValue()).get());
			
			adjustableOrAdjustedOrRelativeDate
				.setUnadjustedDate(MapperS.of(adjustableOrRelativeDate).<AdjustableDate>map("getAdjustableDate", _adjustableOrRelativeDate -> _adjustableOrRelativeDate.getAdjustableDate()).<Date>map("getUnadjustedDate", adjustableDate -> adjustableDate.getUnadjustedDate()).get());
			
			adjustableOrAdjustedOrRelativeDate
				.setDateAdjustments(MapperS.of(adjustableOrRelativeDate).<AdjustableDate>map("getAdjustableDate", _adjustableOrRelativeDate -> _adjustableOrRelativeDate.getAdjustableDate()).<BusinessDayAdjustments>map("getDateAdjustments", adjustableDate -> adjustableDate.getDateAdjustments()).get());
			
			adjustableOrAdjustedOrRelativeDate
				.getOrCreateRelativeDate()
				.setAdjustedDate(MapperUtils.runSingle(() -> {
					if (exists(MapperS.of(relativeDate(adjustableOrRelativeDate).get())).getOrDefault(false)) {
						return MapperS.of(relativeDate(adjustableOrRelativeDate).get()).<Date>map("getAdjustedDate", relativeDateOffset -> relativeDateOffset.getAdjustedDate());
					}
					else {
						return null;
					}
				}).get());
			
			adjustableOrAdjustedOrRelativeDate
				.getOrCreateRelativeDate()
				.setBusinessCenters(MapperUtils.runSinglePolymorphic(() -> {
					if (exists(MapperS.of(relativeDate(adjustableOrRelativeDate).get())).getOrDefault(false)) {
						return MapperS.of(relativeDate(adjustableOrRelativeDate).get()).<BusinessCenters>map("getBusinessCenters", relativeDateOffset -> relativeDateOffset.getBusinessCenters());
					}
					else {
						return null;
					}
				}).get());
			
			adjustableOrAdjustedOrRelativeDate
				.getOrCreateRelativeDate()
				.setBusinessDayConvention(MapperUtils.runSingle(() -> {
					if (exists(MapperS.of(relativeDate(adjustableOrRelativeDate).get())).getOrDefault(false)) {
						return MapperS.of(relativeDate(adjustableOrRelativeDate).get()).<BusinessDayConventionEnum>map("getBusinessDayConvention", relativeDateOffset -> relativeDateOffset.getBusinessDayConvention());
					}
					else {
						return null;
					}
				}).get());
			
			adjustableOrAdjustedOrRelativeDate
				.getOrCreateRelativeDate()
				.setDateRelativeToValue(MapperUtils.runSingle(() -> {
					if (exists(MapperS.of(relativeDate(adjustableOrRelativeDate).get())).getOrDefault(false)) {
						return MapperS.of(relativeDate(adjustableOrRelativeDate).get()).<ReferenceWithMetaDate>map("getDateRelativeTo", relativeDateOffset -> relativeDateOffset.getDateRelativeTo()).<Date>map("getValue", _f->_f.getValue());
					}
					else {
						return null;
					}
				}).get());
			
			adjustableOrAdjustedOrRelativeDate
				.getOrCreateRelativeDate()
				.setDayType(MapperUtils.runSingle(() -> {
					if (exists(MapperS.of(relativeDate(adjustableOrRelativeDate).get())).getOrDefault(false)) {
						return MapperS.of(relativeDate(adjustableOrRelativeDate).get()).<DayTypeEnum>map("getDayType", offset -> offset.getDayType());
					}
					else {
						return null;
					}
				}).get());
			
			adjustableOrAdjustedOrRelativeDate
				.getOrCreateRelativeDate()
				.setPeriod(MapperUtils.runSingle(() -> {
					if (exists(MapperS.of(relativeDate(adjustableOrRelativeDate).get())).getOrDefault(false)) {
						return MapperS.of(relativeDate(adjustableOrRelativeDate).get()).<PeriodEnum>map("getPeriod", period -> period.getPeriod());
					}
					else {
						return null;
					}
				}).get());
			
			adjustableOrAdjustedOrRelativeDate
				.getOrCreateRelativeDate()
				.setPeriodMultiplier(MapperUtils.runSingle(() -> {
					if (exists(MapperS.of(relativeDate(adjustableOrRelativeDate).get())).getOrDefault(false)) {
						return MapperS.of(relativeDate(adjustableOrRelativeDate).get()).<Integer>map("getPeriodMultiplier", period -> period.getPeriodMultiplier());
					}
					else {
						return null;
					}
				}).get());
			
			return Optional.ofNullable(adjustableOrAdjustedOrRelativeDate)
				.map(o -> o.prune())
				.orElse(null);
		}
		
		@Override
		protected Mapper<? extends AdjustedRelativeDateOffset> relativeDate(AdjustableOrRelativeDate adjustableOrRelativeDate) {
			return MapperS.of(adjustableOrRelativeDate).<AdjustedRelativeDateOffset>map("getRelativeDate", _adjustableOrRelativeDate -> _adjustableOrRelativeDate.getRelativeDate());
		}
	}
}
