package cdm.base.datetime.functions;

import cdm.base.datetime.BusinessCenterEnum;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.functions.RosettaFunction;
import com.rosetta.model.lib.mapper.MapperC;
import com.rosetta.model.lib.records.Date;
import java.util.ArrayList;
import java.util.List;
import javax.inject.Inject;

import static com.rosetta.model.lib.expression.ExpressionOperators.*;

@ImplementedBy(BusinessCenterHolidaysMultiple.BusinessCenterHolidaysMultipleDefault.class)
public abstract class BusinessCenterHolidaysMultiple implements RosettaFunction {
	
	// RosettaFunction dependencies
	//
	@Inject protected BusinessCenterHolidays businessCenterHolidays;

	/**
	* @param businessCenters The business centers for which the holiday list is required.
	* @return holidayDates The combined list of holidays in all of the supplied business centers.
	*/
	public List<Date> evaluate(List<BusinessCenterEnum> businessCenters) {
		List<Date> holidayDates = doEvaluate(businessCenters);
		
		return holidayDates;
	}

	protected abstract List<Date> doEvaluate(List<BusinessCenterEnum> businessCenters);

	public static class BusinessCenterHolidaysMultipleDefault extends BusinessCenterHolidaysMultiple {
		@Override
		protected List<Date> doEvaluate(List<BusinessCenterEnum> businessCenters) {
			List<Date> holidayDates = new ArrayList<>();
			return assignOutput(holidayDates, businessCenters);
		}
		
		protected List<Date> assignOutput(List<Date> holidayDates, List<BusinessCenterEnum> businessCenters) {
			List<Date> addVar = MapperC.<BusinessCenterEnum>of(businessCenters)
				.mapItemToList(item -> (MapperC<Date>)MapperC.<Date>of(businessCenterHolidays.evaluate(item.get())))
				.apply(item -> item
					.flattenList())
				.apply(item -> distinct(item))
				.apply(item -> item
					.sort()).getMulti();
			holidayDates.addAll(addVar);
			
			return holidayDates;
		}
	}
}
