/*
 * Decompiled with CFR 0.152.
 */
package org.fife.ui.rtextarea;

import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import javax.swing.JScrollPane;
import org.fife.ui.rtextarea.Gutter;
import org.fife.ui.rtextarea.RTextArea;

public class RTextScrollPane
extends JScrollPane {
    private RTextArea textArea;
    private Gutter gutter;

    public RTextScrollPane() {
        this(null, true);
    }

    public RTextScrollPane(RTextArea rTextArea) {
        this(rTextArea, true);
    }

    public RTextScrollPane(RTextArea rTextArea, boolean bl) {
        this(rTextArea, bl, Color.GRAY);
    }

    public RTextScrollPane(RTextArea rTextArea, boolean bl, Color color) {
        super(rTextArea);
        this.textArea = rTextArea;
        Font font = new Font("Monospaced", 0, 12);
        this.gutter = new Gutter(this.textArea);
        this.gutter.setLineNumberFont(font);
        this.gutter.setLineNumberColor(color);
        this.setLineNumbersEnabled(bl);
        this.setVerticalScrollBarPolicy(22);
        this.setHorizontalScrollBarPolicy(30);
    }

    private void checkGutterVisibility() {
        int n = this.gutter.getComponentCount();
        if (n == 0) {
            if (this.getRowHeader() != null && this.getRowHeader().getView() == this.gutter) {
                this.setRowHeaderView(null);
            }
        } else if (this.getRowHeader() == null || this.getRowHeader().getView() == null) {
            this.setRowHeaderView(this.gutter);
        }
    }

    public Gutter getGutter() {
        return this.gutter;
    }

    public boolean getLineNumbersEnabled() {
        return this.gutter.getLineNumbersEnabled();
    }

    public RTextArea getTextArea() {
        return (RTextArea)this.getViewport().getView();
    }

    public boolean isFoldIndicatorEnabled() {
        return this.gutter.isFoldIndicatorEnabled();
    }

    public boolean isIconRowHeaderEnabled() {
        return this.gutter.isIconRowHeaderEnabled();
    }

    public void setFoldIndicatorEnabled(boolean bl) {
        this.gutter.setFoldIndicatorEnabled(bl);
        this.checkGutterVisibility();
    }

    public void setIconRowHeaderEnabled(boolean bl) {
        this.gutter.setIconRowHeaderEnabled(bl);
        this.checkGutterVisibility();
    }

    public void setLineNumbersEnabled(boolean bl) {
        this.gutter.setLineNumbersEnabled(bl);
        this.checkGutterVisibility();
    }

    public void setViewportView(Component component) {
        if (!(component instanceof RTextArea)) {
            throw new IllegalArgumentException("view must be an RTextArea");
        }
        super.setViewportView(component);
        this.textArea = (RTextArea)component;
        if (this.gutter != null) {
            this.gutter.setTextArea(this.textArea);
        }
    }
}

