/*
 * Decompiled with CFR 0.152.
 */
package org.fife.ui.rsyntaxtextarea;

import java.awt.Container;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.util.ResourceBundle;
import java.util.Stack;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.JScrollPane;
import javax.swing.JViewport;
import javax.swing.KeyStroke;
import javax.swing.UIManager;
import javax.swing.text.BadLocationException;
import javax.swing.text.Caret;
import javax.swing.text.Document;
import javax.swing.text.Element;
import javax.swing.text.Segment;
import javax.swing.text.TextAction;
import org.fife.ui.rsyntaxtextarea.CodeTemplateManager;
import org.fife.ui.rsyntaxtextarea.FoldingAwareIconRowHeader;
import org.fife.ui.rsyntaxtextarea.RSyntaxDocument;
import org.fife.ui.rsyntaxtextarea.RSyntaxTextArea;
import org.fife.ui.rsyntaxtextarea.RSyntaxUtilities;
import org.fife.ui.rsyntaxtextarea.Style;
import org.fife.ui.rsyntaxtextarea.SyntaxScheme;
import org.fife.ui.rsyntaxtextarea.Token;
import org.fife.ui.rsyntaxtextarea.folding.Fold;
import org.fife.ui.rsyntaxtextarea.folding.FoldCollapser;
import org.fife.ui.rsyntaxtextarea.folding.FoldManager;
import org.fife.ui.rsyntaxtextarea.templates.CodeTemplate;
import org.fife.ui.rtextarea.Gutter;
import org.fife.ui.rtextarea.IconRowHeader;
import org.fife.ui.rtextarea.RTextArea;
import org.fife.ui.rtextarea.RTextAreaEditorKit;
import org.fife.ui.rtextarea.RecordableTextAction;

public class RSyntaxTextAreaEditorKit
extends RTextAreaEditorKit {
    private static final long serialVersionUID = 1L;
    public static final String rstaCloseCurlyBraceAction = "RSTA.CloseCurlyBraceAction";
    public static final String rstaCloseMarkupTagAction = "RSTA.CloseMarkupTagAction";
    public static final String rstaCollapseAllFoldsAction = "RSTA.CollapseAllFoldsAction";
    public static final String rstaCollapseAllCommentFoldsAction = "RSTA.CollapseAllCommentFoldsAction";
    public static final String rstaCollapseFoldAction = "RSTA.CollapseFoldAction";
    public static final String rstaCopyAsRtfAction = "RSTA.CopyAsRtfAction";
    public static final String rstaDecreaseIndentAction = "RSTA.DecreaseIndentAction";
    public static final String rstaExpandAllFoldsAction = "RSTA.ExpandAllFoldsAction";
    public static final String rstaExpandFoldAction = "RSTA.ExpandFoldAction";
    public static final String rstaGoToMatchingBracketAction = "RSTA.GoToMatchingBracketAction";
    public static final String rstaPossiblyInsertTemplateAction = "RSTA.TemplateAction";
    public static final String rstaToggleCommentAction = "RSTA.ToggleCommentAction";
    public static final String rstaToggleCurrentFoldAction = "RSTA.ToggleCurrentFoldAction";
    private static final String MSG = "org.fife.ui.rsyntaxtextarea.RSyntaxTextArea";
    private static final ResourceBundle msg = ResourceBundle.getBundle("org.fife.ui.rsyntaxtextarea.RSyntaxTextArea");
    private static final Action[] defaultActions = new Action[]{new CloseCurlyBraceAction(), new CloseMarkupTagAction(), new BeginWordAction("caret-begin-word", false), new BeginWordAction("selection-begin-word", true), new ChangeFoldStateAction("RSTA.CollapseFoldAction", true), new ChangeFoldStateAction("RSTA.ExpandFoldAction", false), new CollapseAllFoldsAction(), new CopyAsRtfAction(), new DecreaseIndentAction(), new DeletePrevWordAction(), new EndAction("caret-end", false), new EndAction("selection-end", true), new EndWordAction("caret-end-word", false), new EndWordAction("caret-end-word", true), new ExpandAllFoldsAction(), new GoToMatchingBracketAction(), new InsertBreakAction(), new InsertTabAction(), new NextWordAction("caret-next-word", false), new NextWordAction("selection-next-word", true), new PossiblyInsertTemplateAction(), new PreviousWordAction("caret-previous-word", false), new PreviousWordAction("selection-previous-word", true), new SelectWordAction(), new ToggleCommentAction()};

    public Document createDefaultDocument() {
        return new RSyntaxDocument("text/plain");
    }

    public IconRowHeader createIconRowHeader(RTextArea rTextArea) {
        return new FoldingAwareIconRowHeader((RSyntaxTextArea)rTextArea);
    }

    public Action[] getActions() {
        return TextAction.augmentList(super.getActions(), defaultActions);
    }

    public static String getString(String string) {
        return msg.getString(string);
    }

    public static class ToggleCurrentFoldAction
    extends FoldRelatedAction {
        private static final long serialVersionUID = 1L;

        public ToggleCurrentFoldAction() {
            super(RSyntaxTextAreaEditorKit.rstaToggleCurrentFoldAction);
            this.setProperties(msg, "Action.ToggleCurrentFold");
        }

        public ToggleCurrentFoldAction(String string, Icon icon, String string2, Integer n, KeyStroke keyStroke) {
            super(string, icon, string2, n, keyStroke);
        }

        public void actionPerformedImpl(ActionEvent actionEvent, RTextArea rTextArea) {
            RSyntaxTextArea rSyntaxTextArea = (RSyntaxTextArea)rTextArea;
            if (rSyntaxTextArea.isCodeFoldingEnabled()) {
                Fold fold = this.getClosestFold(rSyntaxTextArea);
                if (fold != null) {
                    fold.toggleCollapsedState();
                }
                this.possiblyRepaintGutter(rTextArea);
            } else {
                UIManager.getLookAndFeel().provideErrorFeedback(rSyntaxTextArea);
            }
        }

        public final String getMacroID() {
            return RSyntaxTextAreaEditorKit.rstaToggleCurrentFoldAction;
        }
    }

    public static class ToggleCommentAction
    extends RecordableTextAction {
        public ToggleCommentAction() {
            super(RSyntaxTextAreaEditorKit.rstaToggleCommentAction);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void actionPerformedImpl(ActionEvent actionEvent, RTextArea rTextArea) {
            int n;
            int n2;
            if (!rTextArea.isEditable() || !rTextArea.isEnabled()) {
                UIManager.getLookAndFeel().provideErrorFeedback(rTextArea);
                return;
            }
            RSyntaxDocument rSyntaxDocument = (RSyntaxDocument)rTextArea.getDocument();
            String[] stringArray = rSyntaxDocument.getLineCommentStartAndEnd();
            if (stringArray == null) {
                UIManager.getLookAndFeel().provideErrorFeedback(rTextArea);
                return;
            }
            Element element = rSyntaxDocument.getDefaultRootElement();
            Caret caret = rTextArea.getCaret();
            int n3 = caret.getDot();
            int n4 = caret.getMark();
            int n5 = element.getElementIndex(n3);
            int n6 = Math.min(n5, n2 = element.getElementIndex(n4));
            if (n6 != (n = Math.max(n5, n2))) {
                Element element2 = element.getElement(n);
                if (Math.max(n3, n4) == element2.getStartOffset()) {
                    --n;
                }
            }
            rTextArea.beginAtomicEdit();
            try {
                boolean bl = this.getDoAdd(rSyntaxDocument, element, n6, n, stringArray);
                for (n5 = n6; n5 <= n; ++n5) {
                    Element element3 = element.getElement(n5);
                    this.handleToggleComment(element3, rSyntaxDocument, stringArray, bl);
                }
            }
            catch (BadLocationException badLocationException) {
                badLocationException.printStackTrace();
                UIManager.getLookAndFeel().provideErrorFeedback(rTextArea);
            }
            finally {
                rTextArea.endAtomicEdit();
            }
        }

        private boolean getDoAdd(Document document, Element element, int n, int n2, String[] stringArray) throws BadLocationException {
            boolean bl = false;
            for (int i = n; i <= n2; ++i) {
                Element element2 = element.getElement(i);
                int n3 = element2.getStartOffset();
                String string = document.getText(n3, element2.getEndOffset() - n3 - 1);
                if (string.startsWith(stringArray[0]) && (stringArray[1] == null || string.endsWith(stringArray[1]))) continue;
                bl = true;
                break;
            }
            return bl;
        }

        private void handleToggleComment(Element element, Document document, String[] stringArray, boolean bl) throws BadLocationException {
            int n = element.getStartOffset();
            int n2 = element.getEndOffset() - 1;
            if (bl) {
                document.insertString(n, stringArray[0], null);
                if (stringArray[1] != null) {
                    document.insertString(n2 + stringArray[0].length(), stringArray[1], null);
                }
            } else {
                document.remove(n, stringArray[0].length());
                if (stringArray[1] != null) {
                    int n3 = stringArray[1].length();
                    document.remove(n2 - stringArray[0].length() - n3, n3);
                }
            }
        }

        public final String getMacroID() {
            return RSyntaxTextAreaEditorKit.rstaToggleCommentAction;
        }
    }

    public static class SelectWordAction
    extends RTextAreaEditorKit.SelectWordAction {
        protected void createActions() {
            this.start = new BeginWordAction("pigdog", false);
            this.end = new EndWordAction("pigdog", true);
        }
    }

    public static class PreviousWordAction
    extends RTextAreaEditorKit.PreviousWordAction {
        private Segment seg = new Segment();

        public PreviousWordAction(String string, boolean bl) {
            super(string, bl);
        }

        protected int getPreviousWord(RTextArea rTextArea, int n) throws BadLocationException {
            int n2;
            if (n == 0) {
                return n;
            }
            RSyntaxDocument rSyntaxDocument = (RSyntaxDocument)rTextArea.getDocument();
            Element element = rSyntaxDocument.getDefaultRootElement();
            int n3 = element.getElement(n2 = element.getElementIndex(n)).getStartOffset();
            if (n == n3) {
                RSyntaxTextArea rSyntaxTextArea = (RSyntaxTextArea)rTextArea;
                if (rSyntaxTextArea.isCodeFoldingEnabled()) {
                    FoldManager foldManager = rSyntaxTextArea.getFoldManager();
                    while (--n2 >= 0 && foldManager.isLineHidden(n2)) {
                    }
                    if (n2 >= 0) {
                        n = element.getElement(n2).getEndOffset() - 1;
                    }
                    return n;
                }
                return n3 - 1;
            }
            rSyntaxDocument.getText(n3, n - n3, this.seg);
            char c = this.seg.last();
            while (Character.isWhitespace(c)) {
                c = this.seg.previous();
            }
            if (Character.isLetterOrDigit(c)) {
                while (Character.isLetterOrDigit(c = this.seg.previous())) {
                }
            } else if (!Character.isWhitespace(c)) {
                while ((c = this.seg.previous()) != '\uffff' && !Character.isLetterOrDigit(c) && !Character.isWhitespace(c)) {
                }
            }
            n -= this.seg.getEndIndex() - this.seg.getIndex();
            if (c != '\uffff') {
                ++n;
            }
            return n;
        }
    }

    public static class PossiblyInsertTemplateAction
    extends RecordableTextAction {
        private static final long serialVersionUID = 1L;

        public PossiblyInsertTemplateAction() {
            super(RSyntaxTextAreaEditorKit.rstaPossiblyInsertTemplateAction);
        }

        public void actionPerformedImpl(ActionEvent actionEvent, RTextArea rTextArea) {
            block7: {
                if (!rTextArea.isEditable() || !rTextArea.isEnabled()) {
                    return;
                }
                RSyntaxTextArea rSyntaxTextArea = (RSyntaxTextArea)rTextArea;
                if (RSyntaxTextArea.getTemplatesEnabled()) {
                    Document document = rTextArea.getDocument();
                    if (document != null) {
                        try {
                            CodeTemplate codeTemplate;
                            CodeTemplateManager codeTemplateManager = RSyntaxTextArea.getCodeTemplateManager();
                            CodeTemplate codeTemplate2 = codeTemplate = codeTemplateManager == null ? null : codeTemplateManager.getTemplate(rSyntaxTextArea);
                            if (codeTemplate != null) {
                                codeTemplate.invoke(rSyntaxTextArea);
                                break block7;
                            }
                            this.doDefaultInsert(rSyntaxTextArea);
                        }
                        catch (BadLocationException badLocationException) {
                            UIManager.getLookAndFeel().provideErrorFeedback(rTextArea);
                        }
                    }
                } else {
                    this.doDefaultInsert(rSyntaxTextArea);
                }
            }
        }

        private final void doDefaultInsert(RTextArea rTextArea) {
            rTextArea.replaceSelection(" ");
        }

        public final String getMacroID() {
            return RSyntaxTextAreaEditorKit.rstaPossiblyInsertTemplateAction;
        }
    }

    public static class NextWordAction
    extends RTextAreaEditorKit.NextWordAction {
        private Segment seg = new Segment();

        public NextWordAction(String string, boolean bl) {
            super(string, bl);
        }

        protected int getNextWord(RTextArea rTextArea, int n) throws BadLocationException {
            int n2;
            RSyntaxDocument rSyntaxDocument = (RSyntaxDocument)rTextArea.getDocument();
            if (n == rSyntaxDocument.getLength()) {
                return n;
            }
            Element element = rSyntaxDocument.getDefaultRootElement();
            int n3 = element.getElement(n2 = element.getElementIndex(n)).getEndOffset() - 1;
            if (n == n3) {
                RSyntaxTextArea rSyntaxTextArea = (RSyntaxTextArea)rTextArea;
                if (rSyntaxTextArea.isCodeFoldingEnabled()) {
                    FoldManager foldManager = rSyntaxTextArea.getFoldManager();
                    int n4 = element.getElementCount();
                    while (++n2 < n4 && foldManager.isLineHidden(n2)) {
                    }
                    if (n2 < n4) {
                        n = element.getElement(n2).getStartOffset();
                    }
                    return n;
                }
                return n + 1;
            }
            rSyntaxDocument.getText(n, n3 - n, this.seg);
            char c = this.seg.first();
            if (Character.isLetterOrDigit(c)) {
                while (Character.isLetterOrDigit(c = this.seg.next())) {
                }
            } else if (!Character.isWhitespace(c)) {
                while ((c = this.seg.next()) != '\uffff' && !Character.isLetterOrDigit(c) && !Character.isWhitespace(c)) {
                }
            }
            while (Character.isWhitespace(c)) {
                c = this.seg.next();
            }
            return n += this.seg.getIndex() - this.seg.getBeginIndex();
        }
    }

    public static class InsertTabAction
    extends RecordableTextAction {
        private static final long serialVersionUID = 1L;

        public InsertTabAction() {
            super("insert-tab");
        }

        public InsertTabAction(String string) {
            super(string);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public void actionPerformedImpl(ActionEvent actionEvent, RTextArea rTextArea) {
            int n;
            if (!rTextArea.isEditable() || !rTextArea.isEnabled()) {
                UIManager.getLookAndFeel().provideErrorFeedback(rTextArea);
                return;
            }
            Document document = rTextArea.getDocument();
            Element element = document.getDefaultRootElement();
            Caret caret = rTextArea.getCaret();
            int n2 = caret.getDot();
            int n3 = caret.getMark();
            int n4 = element.getElementIndex(n2);
            if (n4 != (n = element.getElementIndex(n3))) {
                int n5 = Math.min(n4, n);
                int n6 = Math.max(n4, n);
                String string = "\t";
                if (rTextArea.getTabsEmulated()) {
                    StringBuffer stringBuffer = new StringBuffer();
                    int n7 = rTextArea.getTabSize();
                    for (int i = 0; i < n7; ++i) {
                        stringBuffer.append(' ');
                    }
                    string = stringBuffer.toString();
                }
                rTextArea.beginAtomicEdit();
                try {
                    int n8;
                    Element element2;
                    for (int i = n5; i < n6; ++i) {
                        element2 = element.getElement(i);
                        n8 = element2.getStartOffset();
                        document.insertString(n8, string, null);
                    }
                    element2 = element.getElement(n6);
                    n8 = element2.getStartOffset();
                    if (Math.max(caret.getDot(), caret.getMark()) == n8) return;
                    document.insertString(n8, string, null);
                    return;
                }
                catch (BadLocationException badLocationException) {
                    badLocationException.printStackTrace();
                    UIManager.getLookAndFeel().provideErrorFeedback(rTextArea);
                    return;
                }
                finally {
                    rTextArea.endAtomicEdit();
                }
            } else {
                rTextArea.replaceSelection("\t");
            }
        }

        public final String getMacroID() {
            return "insert-tab";
        }
    }

    public static class InsertBreakAction
    extends RTextAreaEditorKit.InsertBreakAction {
        private static final long serialVersionUID = 1L;

        public void actionPerformedImpl(ActionEvent actionEvent, RTextArea rTextArea) {
            if (!rTextArea.isEditable() || !rTextArea.isEnabled()) {
                UIManager.getLookAndFeel().provideErrorFeedback(rTextArea);
                return;
            }
            RSyntaxTextArea rSyntaxTextArea = (RSyntaxTextArea)rTextArea;
            boolean bl = rSyntaxTextArea.getSelectionStart() == rSyntaxTextArea.getSelectionEnd();
            boolean bl2 = false;
            if (bl) {
                RSyntaxDocument rSyntaxDocument = (RSyntaxDocument)rSyntaxTextArea.getDocument();
                bl2 = rSyntaxDocument.insertBreakSpecialHandling(actionEvent);
            }
            if (!bl2) {
                this.handleInsertBreak(rSyntaxTextArea, bl);
            }
        }

        private static final int atEndOfLine(int n, String string, int n2) {
            for (int i = n; i < n2; ++i) {
                if (RSyntaxUtilities.isWhitespace(string.charAt(i))) continue;
                return i;
            }
            return -1;
        }

        private static final int getOpenBraceCount(RSyntaxDocument rSyntaxDocument) {
            int n = 0;
            Element element = rSyntaxDocument.getDefaultRootElement();
            int n2 = element.getElementCount();
            for (int i = 0; i < n2; ++i) {
                for (Token token = rSyntaxDocument.getTokenListForLine(i); token != null && token.isPaintable(); token = token.getNextToken()) {
                    if (token.type != 22 || token.textCount != 1) continue;
                    char c = token.text[token.textOffset];
                    if (c == '{') {
                        ++n;
                        continue;
                    }
                    if (c != '}') continue;
                    --n;
                }
            }
            return n;
        }

        protected void handleInsertBreak(RSyntaxTextArea rSyntaxTextArea, boolean bl) {
            if (bl && rSyntaxTextArea.isAutoIndentEnabled()) {
                this.insertNewlineWithAutoIndent(rSyntaxTextArea);
            } else {
                rSyntaxTextArea.replaceSelection("\n");
                if (bl) {
                    this.possiblyCloseCurlyBrace(rSyntaxTextArea, null);
                }
            }
        }

        private void insertNewlineWithAutoIndent(RSyntaxTextArea rSyntaxTextArea) {
            try {
                int n = rSyntaxTextArea.getCaretPosition();
                Document document = rSyntaxTextArea.getDocument();
                Element element = document.getDefaultRootElement();
                int n2 = element.getElementIndex(n);
                Element element2 = element.getElement(n2);
                int n3 = element2.getStartOffset();
                int n4 = element2.getEndOffset() - 1;
                int n5 = n4 - n3;
                String string = document.getText(n3, n5);
                String string2 = RSyntaxUtilities.getLeadingWhitespace(string);
                StringBuffer stringBuffer = new StringBuffer("\n");
                stringBuffer.append(string2);
                int n6 = InsertBreakAction.atEndOfLine(n - n3, string, n5);
                if (n6 == -1) {
                    if (string2.length() == n5 && rSyntaxTextArea.isClearWhitespaceLinesEnabled()) {
                        rSyntaxTextArea.setSelectionStart(n3);
                        rSyntaxTextArea.setSelectionEnd(n4);
                    }
                    rSyntaxTextArea.replaceSelection(stringBuffer.toString());
                } else {
                    stringBuffer.append(string.substring(n6));
                    rSyntaxTextArea.replaceRange(stringBuffer.toString(), n, n4);
                    rSyntaxTextArea.setCaretPosition(n + string2.length() + 1);
                }
                if (rSyntaxTextArea.getShouldIndentNextLine(n2)) {
                    rSyntaxTextArea.replaceSelection("\t");
                }
                this.possiblyCloseCurlyBrace(rSyntaxTextArea, string2);
            }
            catch (BadLocationException badLocationException) {
                rSyntaxTextArea.replaceSelection("\n");
                badLocationException.printStackTrace();
            }
        }

        private void possiblyCloseCurlyBrace(RSyntaxTextArea rSyntaxTextArea, String string) {
            RSyntaxDocument rSyntaxDocument = (RSyntaxDocument)rSyntaxTextArea.getDocument();
            if (rSyntaxTextArea.getCloseCurlyBraces() && rSyntaxDocument.getCurlyBracesDenoteCodeBlocks()) {
                int n = rSyntaxTextArea.getCaretLineNumber();
                Token token = rSyntaxDocument.getTokenListForLine(n - 1);
                if ((token = token.getLastNonCommentNonWhitespaceToken()) != null && token.isLeftCurly() && InsertBreakAction.getOpenBraceCount(rSyntaxDocument) > 0) {
                    StringBuffer stringBuffer = new StringBuffer();
                    if (n == rSyntaxTextArea.getLineCount() - 1) {
                        stringBuffer.append('\n');
                    }
                    if (string != null) {
                        stringBuffer.append(string);
                    }
                    stringBuffer.append("}\n");
                    int n2 = rSyntaxTextArea.getCaretPosition();
                    int n3 = rSyntaxTextArea.getLineEndOffsetOfCurrentLine();
                    rSyntaxTextArea.insert(stringBuffer.toString(), n3);
                    rSyntaxTextArea.setCaretPosition(n2);
                }
            }
        }
    }

    public static class IncreaseFontSizeAction
    extends RTextAreaEditorKit.IncreaseFontSizeAction {
        private static final long serialVersionUID = 1L;

        public IncreaseFontSizeAction() {
        }

        public IncreaseFontSizeAction(String string, Icon icon, String string2, Integer n, KeyStroke keyStroke) {
            super(string, icon, string2, n, keyStroke);
        }

        public void actionPerformedImpl(ActionEvent actionEvent, RTextArea rTextArea) {
            RSyntaxTextArea rSyntaxTextArea = (RSyntaxTextArea)rTextArea;
            SyntaxScheme syntaxScheme = rSyntaxTextArea.getSyntaxScheme();
            boolean bl = false;
            int n = syntaxScheme.getStyleCount();
            for (int i = 0; i < n; ++i) {
                Font font;
                Style style = syntaxScheme.getStyle(i);
                if (style == null || (font = style.font) == null) continue;
                float f = font.getSize2D();
                float f2 = f + this.increaseAmount;
                if (f2 <= 40.0f) {
                    style.font = font.deriveFont(f2);
                    bl = true;
                    continue;
                }
                if (!(f < 40.0f)) continue;
                style.font = font.deriveFont(40.0f);
                bl = true;
            }
            Font font = rSyntaxTextArea.getFont();
            float f = font.getSize2D();
            float f3 = f + this.increaseAmount;
            if (f3 <= 40.0f) {
                rSyntaxTextArea.setFont(font.deriveFont(f3));
                bl = true;
            } else if (f < 40.0f) {
                rSyntaxTextArea.setFont(font.deriveFont(40.0f));
                bl = true;
            }
            if (bl) {
                rSyntaxTextArea.setSyntaxScheme(syntaxScheme);
                Container container = rSyntaxTextArea.getParent();
                if (container instanceof JViewport && (container = container.getParent()) instanceof JScrollPane) {
                    container.repaint();
                }
            } else {
                UIManager.getLookAndFeel().provideErrorFeedback(rSyntaxTextArea);
            }
        }
    }

    public static class GoToMatchingBracketAction
    extends RecordableTextAction {
        private static final long serialVersionUID = 1L;

        public GoToMatchingBracketAction() {
            super(RSyntaxTextAreaEditorKit.rstaGoToMatchingBracketAction);
        }

        public GoToMatchingBracketAction(String string, Icon icon, String string2, Integer n, KeyStroke keyStroke) {
            super(string, icon, string2, n, keyStroke);
        }

        public void actionPerformedImpl(ActionEvent actionEvent, RTextArea rTextArea) {
            RSyntaxTextArea rSyntaxTextArea = (RSyntaxTextArea)rTextArea;
            int n = RSyntaxUtilities.getMatchingBracketPosition(rSyntaxTextArea);
            if (n > -1) {
                rSyntaxTextArea.setCaretPosition(n + 1);
            } else {
                UIManager.getLookAndFeel().provideErrorFeedback(rSyntaxTextArea);
            }
        }

        public final String getMacroID() {
            return RSyntaxTextAreaEditorKit.rstaGoToMatchingBracketAction;
        }
    }

    static abstract class FoldRelatedAction
    extends RecordableTextAction {
        public FoldRelatedAction(String string) {
            super(string);
        }

        public FoldRelatedAction(String string, Icon icon, String string2, Integer n, KeyStroke keyStroke) {
            super(string, icon, string2, n, keyStroke);
        }

        protected Fold getClosestFold(RSyntaxTextArea rSyntaxTextArea) {
            int n = rSyntaxTextArea.getCaretPosition();
            int n2 = rSyntaxTextArea.getCaretLineNumber();
            FoldManager foldManager = rSyntaxTextArea.getFoldManager();
            Fold fold = foldManager.getFoldForLine(n2);
            if (fold == null) {
                fold = foldManager.getDeepestOpenFoldContaining(n);
            }
            return fold;
        }

        protected void possiblyRepaintGutter(RTextArea rTextArea) {
            Gutter gutter = RSyntaxUtilities.getGutter(rTextArea);
            if (gutter != null) {
                gutter.repaint();
            }
        }
    }

    public static class ExpandAllFoldsAction
    extends FoldRelatedAction {
        private static final long serialVersionUID = 1L;

        public ExpandAllFoldsAction() {
            this(false);
        }

        public ExpandAllFoldsAction(boolean bl) {
            super(RSyntaxTextAreaEditorKit.rstaExpandAllFoldsAction);
            if (bl) {
                this.setProperties(msg, "Action.ExpandAllFolds");
            }
        }

        public ExpandAllFoldsAction(String string, Icon icon, String string2, Integer n, KeyStroke keyStroke) {
            super(string, icon, string2, n, keyStroke);
        }

        public void actionPerformedImpl(ActionEvent actionEvent, RTextArea rTextArea) {
            RSyntaxTextArea rSyntaxTextArea = (RSyntaxTextArea)rTextArea;
            if (rSyntaxTextArea.isCodeFoldingEnabled()) {
                FoldManager foldManager = rSyntaxTextArea.getFoldManager();
                for (int i = 0; i < foldManager.getFoldCount(); ++i) {
                    this.expand(foldManager.getFold(i));
                }
                this.possiblyRepaintGutter(rSyntaxTextArea);
            } else {
                UIManager.getLookAndFeel().provideErrorFeedback(rSyntaxTextArea);
            }
        }

        private void expand(Fold fold) {
            fold.setCollapsed(false);
            for (int i = 0; i < fold.getChildCount(); ++i) {
                this.expand(fold.getChild(i));
            }
        }

        public final String getMacroID() {
            return RSyntaxTextAreaEditorKit.rstaExpandAllFoldsAction;
        }
    }

    protected static class EndWordAction
    extends RTextAreaEditorKit.EndWordAction {
        private Segment seg = new Segment();

        protected EndWordAction(String string, boolean bl) {
            super(string, bl);
        }

        protected int getWordEnd(RTextArea rTextArea, int n) throws BadLocationException {
            RSyntaxDocument rSyntaxDocument = (RSyntaxDocument)rTextArea.getDocument();
            if (n == rSyntaxDocument.getLength()) {
                return n;
            }
            int n2 = rTextArea.getLineOfOffset(n);
            int n3 = rTextArea.getLineEndOffset(n2);
            if (n2 != rTextArea.getLineCount() - 1) {
                --n3;
            }
            if (n == n3) {
                return n3;
            }
            rSyntaxDocument.getText(n, n3 - n, this.seg);
            char c = this.seg.first();
            if (Character.isLetterOrDigit(c)) {
                while (Character.isLetterOrDigit(c = this.seg.next())) {
                }
            } else if (Character.isWhitespace(c)) {
                while (Character.isWhitespace(c = this.seg.next())) {
                }
            }
            return n += this.seg.getIndex() - this.seg.getBeginIndex();
        }
    }

    public static class EndAction
    extends RTextAreaEditorKit.EndAction {
        public EndAction(String string, boolean bl) {
            super(string, bl);
        }

        protected int getVisibleEnd(RTextArea rTextArea) {
            RSyntaxTextArea rSyntaxTextArea = (RSyntaxTextArea)rTextArea;
            return rSyntaxTextArea.getLastVisibleOffset();
        }
    }

    public static class DeletePrevWordAction
    extends RTextAreaEditorKit.DeletePrevWordAction {
        private Segment seg = new Segment();

        protected int getPreviousWordStart(RTextArea rTextArea, int n) throws BadLocationException {
            if (n == 0) {
                return n;
            }
            RSyntaxDocument rSyntaxDocument = (RSyntaxDocument)rTextArea.getDocument();
            int n2 = rTextArea.getLineOfOffset(n);
            int n3 = rTextArea.getLineStartOffset(n2);
            if (n == n3) {
                return n3 - 1;
            }
            int n4 = rTextArea.getLineEndOffset(n2);
            if (n2 != rTextArea.getLineCount() - 1) {
                --n4;
            }
            rSyntaxDocument.getText(n3, n4 - n3, this.seg);
            int n5 = this.seg.getBeginIndex() + (n - n3) - 1;
            this.seg.setIndex(n5);
            char c = this.seg.current();
            if (Character.isWhitespace(c)) {
                while (Character.isWhitespace(c = this.seg.previous())) {
                }
            }
            if (Character.isLetterOrDigit(c)) {
                while (Character.isLetterOrDigit(c = this.seg.previous())) {
                }
            } else {
                while (!Character.isWhitespace(c) && !Character.isLetterOrDigit(c) && c != '\uffff') {
                    c = this.seg.previous();
                }
            }
            if (c == '\uffff') {
                return n3;
            }
            return n -= n5 - this.seg.getIndex();
        }
    }

    public static class DecreaseIndentAction
    extends RecordableTextAction {
        private static final long serialVersionUID = 1L;
        private Segment s = new Segment();

        public DecreaseIndentAction() {
            this(RSyntaxTextAreaEditorKit.rstaDecreaseIndentAction);
        }

        public DecreaseIndentAction(String string) {
            super(string);
        }

        public void actionPerformedImpl(ActionEvent actionEvent, RTextArea rTextArea) {
            if (!rTextArea.isEditable() || !rTextArea.isEnabled()) {
                UIManager.getLookAndFeel().provideErrorFeedback(rTextArea);
                return;
            }
            Document document = rTextArea.getDocument();
            Element element = document.getDefaultRootElement();
            Caret caret = rTextArea.getCaret();
            int n = caret.getDot();
            int n2 = caret.getMark();
            int n3 = element.getElementIndex(n);
            int n4 = rTextArea.getTabSize();
            if (n != n2) {
                int n5 = element.getElementIndex(n2);
                n = Math.min(n3, n5);
                n2 = Math.max(n3, n5);
                try {
                    Element element2;
                    for (n3 = n; n3 < n2; ++n3) {
                        element2 = element.getElement(n3);
                        this.handleDecreaseIndent(element2, document, n4);
                    }
                    element2 = element.getElement(n2);
                    int n6 = element2.getStartOffset();
                    if (Math.max(caret.getDot(), caret.getMark()) != n6) {
                        this.handleDecreaseIndent(element2, document, n4);
                    }
                }
                catch (BadLocationException badLocationException) {
                    badLocationException.printStackTrace();
                    UIManager.getLookAndFeel().provideErrorFeedback(rTextArea);
                }
            } else {
                Element element3 = element.getElement(n3);
                try {
                    this.handleDecreaseIndent(element3, document, n4);
                }
                catch (BadLocationException badLocationException) {
                    badLocationException.printStackTrace();
                    UIManager.getLookAndFeel().provideErrorFeedback(rTextArea);
                }
            }
        }

        public final String getMacroID() {
            return RSyntaxTextAreaEditorKit.rstaDecreaseIndentAction;
        }

        private final void handleDecreaseIndent(Element element, Document document, int n) throws BadLocationException {
            int n2 = element.getStartOffset();
            int n3 = element.getEndOffset() - 1;
            document.getText(n2, n3 - n2, this.s);
            int n4 = this.s.offset;
            n3 = n4 + this.s.count;
            if (n3 > n4) {
                if (this.s.array[n4] == '\t') {
                    document.remove(n2, 1);
                } else if (this.s.array[n4] == ' ') {
                    int n5;
                    ++n4;
                    for (n5 = 1; n4 < n3 && this.s.array[n4] == ' ' && n5 < n; ++n4, ++n5) {
                    }
                    document.remove(n2, n5);
                }
            }
        }
    }

    public static class DecreaseFontSizeAction
    extends RTextAreaEditorKit.DecreaseFontSizeAction {
        private static final long serialVersionUID = 1L;

        public DecreaseFontSizeAction() {
        }

        public DecreaseFontSizeAction(String string, Icon icon, String string2, Integer n, KeyStroke keyStroke) {
            super(string, icon, string2, n, keyStroke);
        }

        public void actionPerformedImpl(ActionEvent actionEvent, RTextArea rTextArea) {
            RSyntaxTextArea rSyntaxTextArea = (RSyntaxTextArea)rTextArea;
            SyntaxScheme syntaxScheme = rSyntaxTextArea.getSyntaxScheme();
            boolean bl = false;
            int n = syntaxScheme.getStyleCount();
            for (int i = 0; i < n; ++i) {
                Font font;
                Style style = syntaxScheme.getStyle(i);
                if (style == null || (font = style.font) == null) continue;
                float f = font.getSize2D();
                float f2 = f - this.decreaseAmount;
                if (f2 >= 2.0f) {
                    style.font = font.deriveFont(f2);
                    bl = true;
                    continue;
                }
                if (!(f > 2.0f)) continue;
                style.font = font.deriveFont(2.0f);
                bl = true;
            }
            Font font = rSyntaxTextArea.getFont();
            float f = font.getSize2D();
            float f3 = f - this.decreaseAmount;
            if (f3 >= 2.0f) {
                rSyntaxTextArea.setFont(font.deriveFont(f3));
                bl = true;
            } else if (f > 2.0f) {
                rSyntaxTextArea.setFont(font.deriveFont(2.0f));
                bl = true;
            }
            if (bl) {
                rSyntaxTextArea.setSyntaxScheme(syntaxScheme);
                Container container = rSyntaxTextArea.getParent();
                if (container instanceof JViewport && (container = container.getParent()) instanceof JScrollPane) {
                    container.repaint();
                }
            } else {
                UIManager.getLookAndFeel().provideErrorFeedback(rSyntaxTextArea);
            }
        }
    }

    public static class CopyAsRtfAction
    extends RecordableTextAction {
        private static final long serialVersionUID = 1L;

        public CopyAsRtfAction() {
            super(RSyntaxTextAreaEditorKit.rstaCopyAsRtfAction);
        }

        public CopyAsRtfAction(String string, Icon icon, String string2, Integer n, KeyStroke keyStroke) {
            super(string, icon, string2, n, keyStroke);
        }

        public void actionPerformedImpl(ActionEvent actionEvent, RTextArea rTextArea) {
            ((RSyntaxTextArea)rTextArea).copyAsRtf();
            rTextArea.requestFocusInWindow();
        }

        public final String getMacroID() {
            return this.getName();
        }
    }

    public static class CollapseAllFoldsAction
    extends FoldRelatedAction {
        private static final long serialVersionUID = 1L;

        public CollapseAllFoldsAction() {
            this(false);
        }

        public CollapseAllFoldsAction(boolean bl) {
            super(RSyntaxTextAreaEditorKit.rstaCollapseAllFoldsAction);
            if (bl) {
                this.setProperties(msg, "Action.CollapseAllFolds");
            }
        }

        public CollapseAllFoldsAction(String string, Icon icon, String string2, Integer n, KeyStroke keyStroke) {
            super(string, icon, string2, n, keyStroke);
        }

        public void actionPerformedImpl(ActionEvent actionEvent, RTextArea rTextArea) {
            RSyntaxTextArea rSyntaxTextArea = (RSyntaxTextArea)rTextArea;
            if (rSyntaxTextArea.isCodeFoldingEnabled()) {
                FoldCollapser foldCollapser = new FoldCollapser(){

                    public boolean getShouldCollapse(Fold fold) {
                        return true;
                    }
                };
                foldCollapser.collapseFolds(rSyntaxTextArea.getFoldManager());
                this.possiblyRepaintGutter(rTextArea);
            } else {
                UIManager.getLookAndFeel().provideErrorFeedback(rSyntaxTextArea);
            }
        }

        public final String getMacroID() {
            return RSyntaxTextAreaEditorKit.rstaCollapseAllFoldsAction;
        }
    }

    public static class CollapseAllCommentFoldsAction
    extends FoldRelatedAction {
        private static final long serialVersionUID = 1L;

        public CollapseAllCommentFoldsAction() {
            super(RSyntaxTextAreaEditorKit.rstaCollapseAllCommentFoldsAction);
            this.setProperties(msg, "Action.CollapseCommentFolds");
        }

        public CollapseAllCommentFoldsAction(String string, Icon icon, String string2, Integer n, KeyStroke keyStroke) {
            super(string, icon, string2, n, keyStroke);
        }

        public void actionPerformedImpl(ActionEvent actionEvent, RTextArea rTextArea) {
            RSyntaxTextArea rSyntaxTextArea = (RSyntaxTextArea)rTextArea;
            if (rSyntaxTextArea.isCodeFoldingEnabled()) {
                FoldCollapser foldCollapser = new FoldCollapser();
                foldCollapser.collapseFolds(rSyntaxTextArea.getFoldManager());
                this.possiblyRepaintGutter(rTextArea);
            } else {
                UIManager.getLookAndFeel().provideErrorFeedback(rSyntaxTextArea);
            }
        }

        public final String getMacroID() {
            return RSyntaxTextAreaEditorKit.rstaCollapseAllCommentFoldsAction;
        }
    }

    public static class CloseMarkupTagAction
    extends RecordableTextAction {
        private static final long serialVersionUID = 1L;

        public CloseMarkupTagAction() {
            super(RSyntaxTextAreaEditorKit.rstaCloseMarkupTagAction);
        }

        public void actionPerformedImpl(ActionEvent actionEvent, RTextArea rTextArea) {
            if (!rTextArea.isEditable() || !rTextArea.isEnabled()) {
                UIManager.getLookAndFeel().provideErrorFeedback(rTextArea);
                return;
            }
            RSyntaxTextArea rSyntaxTextArea = (RSyntaxTextArea)rTextArea;
            RSyntaxDocument rSyntaxDocument = (RSyntaxDocument)rSyntaxTextArea.getDocument();
            Caret caret = rSyntaxTextArea.getCaret();
            boolean bl = caret.getDot() != caret.getMark();
            rSyntaxTextArea.replaceSelection("/");
            int n = caret.getDot();
            if (rSyntaxDocument.getLanguageIsMarkup() && rSyntaxDocument.getCompleteMarkupCloseTags() && !bl && rSyntaxTextArea.getCloseMarkupTags() && n > 1) {
                try {
                    char c = rSyntaxDocument.charAt(n - 2);
                    if (c == '<' || c == '[') {
                        String string;
                        Token token = rSyntaxDocument.getTokenListForLine(rSyntaxTextArea.getCaretLineNumber());
                        if ((token = RSyntaxUtilities.getTokenAtOffset(token, n - 1)) != null && token.type == 25 && (string = this.discoverTagName(rSyntaxDocument, n)) != null) {
                            rSyntaxTextArea.replaceSelection(string + (char)(c + 2));
                        }
                    }
                }
                catch (BadLocationException badLocationException) {
                    UIManager.getLookAndFeel().provideErrorFeedback(rSyntaxTextArea);
                    badLocationException.printStackTrace();
                }
            }
        }

        private String discoverTagName(RSyntaxDocument rSyntaxDocument, int n) {
            Stack<String> stack = new Stack<String>();
            Element element = rSyntaxDocument.getDefaultRootElement();
            int n2 = element.getElementIndex(n);
            for (int i = 0; i <= n2; ++i) {
                block1: for (Token token = rSyntaxDocument.getTokenListForLine(i); token != null && token.isPaintable(); token = token.getNextToken()) {
                    if (token.type != 25) continue;
                    if (token.isSingleChar('<') || token.isSingleChar('[')) {
                        for (token = token.getNextToken(); token != null && token.isPaintable(); token = token.getNextToken()) {
                            if (token.type != 26 && token.type != 27) continue;
                            stack.push(token.getLexeme());
                            continue block1;
                        }
                        continue;
                    }
                    if (token.textCount == 2 && token.text[token.textOffset] == '/' && (token.text[token.textOffset + 1] == '>' || token.text[token.textOffset + 1] == ']')) {
                        if (stack.isEmpty()) continue;
                        stack.pop();
                        continue;
                    }
                    if (token.textCount != 2 || token.text[token.textOffset] != '<' && token.text[token.textOffset] != '[' || token.text[token.textOffset + 1] != '/') continue;
                    String string = null;
                    if (!stack.isEmpty()) {
                        string = (String)stack.pop();
                    }
                    if (token.offset + token.textCount < n) continue;
                    return string;
                }
            }
            return null;
        }

        public String getMacroID() {
            return this.getName();
        }
    }

    public static class CloseCurlyBraceAction
    extends RecordableTextAction {
        private static final long serialVersionUID = 1L;
        private Segment seg = new Segment();

        public CloseCurlyBraceAction() {
            super(RSyntaxTextAreaEditorKit.rstaCloseCurlyBraceAction);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void actionPerformedImpl(ActionEvent actionEvent, RTextArea rTextArea) {
            block14: {
                boolean bl;
                RSyntaxTextArea rSyntaxTextArea = (RSyntaxTextArea)rTextArea;
                RSyntaxDocument rSyntaxDocument = (RSyntaxDocument)rSyntaxTextArea.getDocument();
                boolean bl2 = bl = rSyntaxTextArea.isAutoIndentEnabled() && rSyntaxDocument.getCurlyBracesDenoteCodeBlocks();
                if (bl) {
                    rTextArea.beginAtomicEdit();
                }
                try {
                    int n;
                    rTextArea.replaceSelection("}");
                    if (!bl) break block14;
                    Element element = rSyntaxDocument.getDefaultRootElement();
                    int n2 = rSyntaxTextArea.getCaretPosition() - 1;
                    int n3 = element.getElementIndex(n2);
                    Element element2 = element.getElement(n3);
                    int n4 = element2.getStartOffset();
                    try {
                        rSyntaxDocument.getText(n4, n2 - n4, this.seg);
                    }
                    catch (BadLocationException badLocationException) {
                        badLocationException.printStackTrace();
                        if (bl) {
                            rTextArea.endAtomicEdit();
                        }
                        return;
                    }
                    for (n = 0; n < this.seg.count; ++n) {
                        char c = this.seg.array[this.seg.offset + n];
                        if (Character.isWhitespace(c)) continue;
                        return;
                    }
                    n = RSyntaxUtilities.getMatchingBracketPosition(rSyntaxTextArea);
                    if (n <= -1) break block14;
                    try {
                        String string = RSyntaxUtilities.getLeadingWhitespace(rSyntaxDocument, n);
                        rSyntaxTextArea.replaceRange(string, n4, n2);
                    }
                    catch (BadLocationException badLocationException) {
                        badLocationException.printStackTrace();
                        if (bl) {
                            rTextArea.endAtomicEdit();
                        }
                        return;
                    }
                }
                finally {
                    if (bl) {
                        rTextArea.endAtomicEdit();
                    }
                }
            }
        }

        public final String getMacroID() {
            return RSyntaxTextAreaEditorKit.rstaCloseCurlyBraceAction;
        }
    }

    public static class ChangeFoldStateAction
    extends FoldRelatedAction {
        private boolean collapse;

        public ChangeFoldStateAction(String string, boolean bl) {
            super(string);
            this.collapse = bl;
        }

        public ChangeFoldStateAction(String string, Icon icon, String string2, Integer n, KeyStroke keyStroke) {
            super(string, icon, string2, n, keyStroke);
        }

        public void actionPerformedImpl(ActionEvent actionEvent, RTextArea rTextArea) {
            RSyntaxTextArea rSyntaxTextArea = (RSyntaxTextArea)rTextArea;
            if (rSyntaxTextArea.isCodeFoldingEnabled()) {
                Fold fold = this.getClosestFold(rSyntaxTextArea);
                if (fold != null) {
                    fold.setCollapsed(this.collapse);
                }
                this.possiblyRepaintGutter(rTextArea);
            } else {
                UIManager.getLookAndFeel().provideErrorFeedback(rSyntaxTextArea);
            }
        }

        public final String getMacroID() {
            return this.getName();
        }
    }

    protected static class BeginWordAction
    extends RTextAreaEditorKit.BeginWordAction {
        private Segment seg = new Segment();

        protected BeginWordAction(String string, boolean bl) {
            super(string, bl);
        }

        protected int getWordStart(RTextArea rTextArea, int n) throws BadLocationException {
            char c;
            if (n == 0) {
                return n;
            }
            RSyntaxDocument rSyntaxDocument = (RSyntaxDocument)rTextArea.getDocument();
            int n2 = rTextArea.getLineOfOffset(n);
            int n3 = rTextArea.getLineStartOffset(n2);
            if (n == n3) {
                return n3;
            }
            int n4 = rTextArea.getLineEndOffset(n2);
            if (n2 != rTextArea.getLineCount() - 1) {
                --n4;
            }
            rSyntaxDocument.getText(n3, n4 - n3, this.seg);
            int n5 = this.seg.getBeginIndex() + (n - n3) - 1;
            this.seg.setIndex(n5);
            char c2 = this.seg.current();
            char c3 = c = n == n4 ? (char)'\u0000' : this.seg.array[this.seg.getIndex() + 1];
            if (Character.isLetterOrDigit(c2)) {
                if (n != n4 && !Character.isLetterOrDigit(c)) {
                    return n;
                }
                while (Character.isLetterOrDigit(c2 = this.seg.previous())) {
                }
            } else if (Character.isWhitespace(c2)) {
                if (n != n4 && !Character.isWhitespace(c)) {
                    return n;
                }
                while (Character.isWhitespace(c2 = this.seg.previous())) {
                }
            }
            n -= n5 - this.seg.getIndex() + 1;
            if (c2 != '\uffff' && c != '\n') {
                ++n;
            }
            return n;
        }
    }
}

