/*
 * Decompiled with CFR 0.152.
 */
package org.fife.ui.rsyntaxtextarea;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.fife.ui.rsyntaxtextarea.TokenMaker;
import org.fife.ui.rsyntaxtextarea.TokenMakerFactory;

public abstract class AbstractTokenMakerFactory
extends TokenMakerFactory {
    private Map tokenMakerMap = new HashMap();

    protected AbstractTokenMakerFactory() {
        this.initTokenMakerMap();
    }

    protected TokenMaker getTokenMakerImpl(String string) {
        TokenMakerCreator tokenMakerCreator = (TokenMakerCreator)this.tokenMakerMap.get(string);
        if (tokenMakerCreator != null) {
            try {
                return tokenMakerCreator.create();
            }
            catch (RuntimeException runtimeException) {
                throw runtimeException;
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        return null;
    }

    protected abstract void initTokenMakerMap();

    public Set keySet() {
        return this.tokenMakerMap.keySet();
    }

    public void putMapping(String string, String string2) {
        this.putMapping(string, string2, null);
    }

    public void putMapping(String string, String string2, ClassLoader classLoader) {
        this.tokenMakerMap.put(string, new TokenMakerCreator(string2, classLoader));
    }

    private static class TokenMakerCreator {
        private String className;
        private ClassLoader cl;

        public TokenMakerCreator(String string, ClassLoader classLoader) {
            this.className = string;
            this.cl = classLoader != null ? classLoader : this.getClass().getClassLoader();
        }

        public TokenMaker create() throws Exception {
            return (TokenMaker)Class.forName(this.className, true, this.cl).newInstance();
        }
    }
}

