/*
 * Decompiled with CFR 0.152.
 */
package org.faktorips.runtime.test;

import java.util.ArrayList;
import java.util.List;
import org.faktorips.runtime.IRuntimeRepository;
import org.faktorips.runtime.test.IpsTest2;
import org.faktorips.runtime.test.IpsTestListener;
import org.faktorips.runtime.test.IpsTestResult;
import org.faktorips.runtime.test.IpsTestSuite;
import org.faktorips.runtime.test.TocHierarchyCreator;

public abstract class AbstractIpsTestRunner
implements IpsTestListener {
    private String repositoryPackages;
    private String additionalRepositoryPackages;
    private List<IRuntimeRepository> repositories;
    private ClassLoader classLoader = this.getClass().getClassLoader();
    private IpsTestSuite testSuite = null;

    public int countTests(String names) throws Exception {
        IpsTest2 test = this.getTest(names);
        if (test == null) {
            return 0;
        }
        if (test instanceof IpsTestSuite) {
            return ((IpsTestSuite)test).countTestCases();
        }
        return 1;
    }

    public List<IpsTest2> getTests() {
        if (this.testSuite == null) {
            return new ArrayList<IpsTest2>(0);
        }
        return this.testSuite.getTests();
    }

    protected List<IRuntimeRepository> getRepositories() throws Exception {
        if (this.repositories == null) {
            this.repositories = this.createRepositories();
        }
        return this.repositories;
    }

    protected ClassLoader getClassLoader() {
        return this.classLoader;
    }

    public void setClassLoader(ClassLoader classLoader) {
        this.classLoader = classLoader;
    }

    public void setRepositoryPackages(String repositoryPackages) {
        this.repositoryPackages = repositoryPackages;
    }

    public String getRepositoryPackages() {
        return this.repositoryPackages;
    }

    protected void setAdditionalRepositoryPackages(String additionalRepositoryPackages) {
        this.additionalRepositoryPackages = additionalRepositoryPackages;
    }

    public void run(String names) throws Exception {
        IpsTest2 test = this.getTest(names);
        IpsTestResult result = new IpsTestResult();
        result.addListener(this);
        result.run(test);
    }

    protected List<String> getRepositoryListFromInputString(String repositoryPackages) {
        return AbstractIpsTestRunner.extractListFromString(repositoryPackages);
    }

    public static List<String> extractListFromString(String input) {
        ArrayList<String> repositoryNameList = new ArrayList<String>();
        if (input != null) {
            String restOfInput = input;
            while (restOfInput.length() > 0) {
                repositoryNameList.add(restOfInput.substring(restOfInput.indexOf("{") + 1, restOfInput.indexOf("}")));
                restOfInput = restOfInput.substring(restOfInput.indexOf("}") + 1);
            }
        }
        return repositoryNameList;
    }

    public static String toStringFromList(List<String> input) {
        String result = "";
        for (String element : input) {
            result = String.valueOf(result) + "{" + element + "}";
        }
        return result;
    }

    private String getFirstTest(String names) {
        String name = "";
        if (names.indexOf("{") >= 0) {
            name = names.substring(names.indexOf("{") + 1, names.indexOf("}"));
        }
        return name;
    }

    private String getNextNames(String names) {
        return names.substring(names.indexOf("}") + 1);
    }

    private IpsTest2 getTest(String names) throws Exception {
        if (this.testSuite != null) {
            return this.testSuite;
        }
        List<String> repositoryNameList = this.getRepositoryListFromInputString(this.repositoryPackages);
        List<String> runtimePackages = AbstractIpsTestRunner.extractListFromString(this.additionalRepositoryPackages);
        IRuntimeRepository additionalRepositories = TocHierarchyCreator.createRuntimeRepository(runtimePackages, this.getClassLoader());
        this.testSuite = new IpsTestSuite("root");
        String nextNames = names;
        List<IRuntimeRepository> createdRepositories = this.getRepositories();
        int i = 0;
        while (i < createdRepositories.size()) {
            if (additionalRepositories != null && !runtimePackages.contains(repositoryNameList.get(i))) {
                additionalRepositories.addDirectlyReferencedRepository(createdRepositories.get(i));
            }
            this.testSuite.addTest(createdRepositories.get(i).getIpsTest(this.getFirstTest(nextNames), additionalRepositories));
            nextNames = this.getNextNames(nextNames);
            ++i;
        }
        return this.testSuite;
    }

    protected abstract List<IRuntimeRepository> createRepositories() throws Exception;
}

