/*
 * Decompiled with CFR 0.152.
 */
package org.faktorips.runtime.internal.toc;

import java.util.Objects;
import org.faktorips.runtime.internal.toc.TocEntry;
import org.w3c.dom.Element;

public abstract class TocEntryObject
extends TocEntry {
    public static final String PROPERTY_ENTRYTYPE = "entryType";
    public static final String PROPERTY_IPS_OBJECT_ID = "ipsObjectId";
    public static final String PROPERTY_IPS_OBJECT_QNAME = "ipsObjectQualifiedName";
    private String ipsObjectId;
    private String ipsObjectQualifiedName;

    protected TocEntryObject(String ipsObjectId, String ipsObjectQualifiedName, String xmlResourceName, String implementationClassName) {
        super(implementationClassName, xmlResourceName);
        this.ipsObjectId = ipsObjectId;
        this.ipsObjectQualifiedName = ipsObjectQualifiedName;
    }

    public String getIpsObjectId() {
        return this.ipsObjectId;
    }

    public String getIpsObjectQualifiedName() {
        return this.ipsObjectQualifiedName;
    }

    @Override
    protected void addToXml(Element entryElement) {
        super.addToXml(entryElement);
        entryElement.setAttribute(PROPERTY_IPS_OBJECT_ID, this.ipsObjectId);
        entryElement.setAttribute(PROPERTY_IPS_OBJECT_QNAME, this.ipsObjectQualifiedName);
    }

    public String toString() {
        return "TocEntry(" + this.getXmlElementTag() + ':' + this.ipsObjectId + ')';
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.ipsObjectId == null ? 0 : this.ipsObjectId.hashCode());
        return 31 * result + (this.ipsObjectQualifiedName == null ? 0 : this.ipsObjectQualifiedName.hashCode());
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj) || !(obj instanceof TocEntryObject)) {
            return false;
        }
        TocEntryObject other = (TocEntryObject)obj;
        return Objects.equals(this.ipsObjectId, other.ipsObjectId) && Objects.equals(this.ipsObjectQualifiedName, other.ipsObjectQualifiedName) && super.equals(obj);
    }
}

