/*
 * Decompiled with CFR 0.152.
 */
package org.faktorips.runtime.formula;

import java.util.LinkedHashMap;
import java.util.Map;
import org.faktorips.runtime.FormulaExecutionException;
import org.faktorips.runtime.formula.IFormulaEvaluator;
import org.faktorips.runtime.util.StringBuilderJoiner;

public abstract class AbstractFormulaEvaluator
implements IFormulaEvaluator {
    public static final String COMPILED_EXPRESSION_XML_TAG = "compiledExpression";
    private final Object object;
    private final Map<String, String> nameToExpressionMap;

    public AbstractFormulaEvaluator(Object object, Map<String, String> nameToExpressionMap) {
        if (object == null) {
            throw new NullPointerException();
        }
        this.object = object;
        this.nameToExpressionMap = nameToExpressionMap;
    }

    @Override
    public Object getObject() {
        return this.object;
    }

    @Override
    public Object evaluate(String formularName, Object ... parameters) {
        try {
            return this.evaluateInternal(formularName, parameters);
        }
        catch (Exception e) {
            StringBuilder parameterValues = new StringBuilder();
            parameterValues.append("Parameters: ");
            StringBuilderJoiner.join(parameterValues, parameters);
            throw new FormulaExecutionException(this.object.toString(), formularName, parameterValues.toString(), e);
        }
    }

    protected abstract Object evaluateInternal(String var1, Object ... var2) throws Exception;

    @Override
    public Map<String, String> getNameToExpressionMap() {
        LinkedHashMap<String, String> map = new LinkedHashMap<String, String>();
        map.putAll(this.nameToExpressionMap);
        return map;
    }
}

