/*
 * Decompiled with CFR 0.152.
 */
package org.fabric3.binding.file.runtime.receiver;

import java.io.File;
import java.util.regex.Pattern;
import org.fabric3.api.binding.file.ServiceAdapter;
import org.fabric3.api.binding.file.annotation.Strategy;
import org.fabric3.binding.file.runtime.receiver.ReceiverMonitor;
import org.fabric3.spi.container.wire.Interceptor;

public class ReceiverConfiguration {
    private String id;
    private File location;
    private Pattern filePattern;
    private File lockDirectory;
    Strategy strategy;
    File errorLocation;
    File archiveLocation;
    private long delay;
    private Interceptor interceptor;
    private ReceiverMonitor monitor;
    private ServiceAdapter adapter;

    public ReceiverConfiguration(String id, File location, String filePattern, Strategy strategy, File errorLocation, File archiveLocation, Interceptor interceptor, ServiceAdapter adapter, long delay, ReceiverMonitor monitor) {
        this.id = id;
        this.location = location;
        this.strategy = strategy;
        this.errorLocation = errorLocation;
        this.archiveLocation = archiveLocation;
        this.filePattern = Pattern.compile(filePattern);
        this.interceptor = interceptor;
        this.adapter = adapter;
        this.delay = delay;
        this.monitor = monitor;
        this.lockDirectory = new File(location, "locks");
    }

    public String getId() {
        return this.id;
    }

    public File getLocation() {
        return this.location;
    }

    public Pattern getFilePattern() {
        return this.filePattern;
    }

    public File getLockDirectory() {
        return this.lockDirectory;
    }

    public Strategy getStrategy() {
        return this.strategy;
    }

    public File getErrorLocation() {
        return this.errorLocation;
    }

    public File getArchiveLocation() {
        return this.archiveLocation;
    }

    public long getDelay() {
        return this.delay;
    }

    public Interceptor getInterceptor() {
        return this.interceptor;
    }

    public ServiceAdapter getAdapter() {
        return this.adapter;
    }

    public ReceiverMonitor getMonitor() {
        return this.monitor;
    }
}

