/*
 * Decompiled with CFR 0.152.
 */
package org.fabric3.binding.file.runtime;

import java.io.File;
import java.net.URI;
import org.fabric3.api.binding.file.ReferenceAdapter;
import org.fabric3.api.host.runtime.HostInfo;
import org.fabric3.binding.file.provision.FileBindingWireTargetDefinition;
import org.fabric3.binding.file.runtime.DefaultReferenceAdapter;
import org.fabric3.binding.file.runtime.ReferenceAdaptorWrapper;
import org.fabric3.binding.file.runtime.sender.FileSystemInterceptor;
import org.fabric3.spi.classloader.ClassLoaderRegistry;
import org.fabric3.spi.container.ContainerException;
import org.fabric3.spi.container.builder.component.TargetWireAttacher;
import org.fabric3.spi.container.component.AtomicComponent;
import org.fabric3.spi.container.component.Component;
import org.fabric3.spi.container.component.ComponentManager;
import org.fabric3.spi.container.objectfactory.ObjectFactory;
import org.fabric3.spi.container.wire.Interceptor;
import org.fabric3.spi.container.wire.InvocationChain;
import org.fabric3.spi.container.wire.Wire;
import org.fabric3.spi.model.physical.PhysicalWireSourceDefinition;
import org.oasisopen.sca.annotation.EagerInit;
import org.oasisopen.sca.annotation.Reference;

@EagerInit
public class FileTargetWireAttacher
implements TargetWireAttacher<FileBindingWireTargetDefinition> {
    private static final ReferenceAdapter ADAPTER = new DefaultReferenceAdapter();
    private ClassLoaderRegistry registry;
    private File baseDir;
    private ComponentManager manager;

    public FileTargetWireAttacher(@Reference ClassLoaderRegistry registry, @Reference ComponentManager manager, @Reference HostInfo hostInfo) {
        this.registry = registry;
        this.manager = manager;
        this.baseDir = new File(hostInfo.getDataDir(), "outbox");
    }

    public void attach(PhysicalWireSourceDefinition source, FileBindingWireTargetDefinition target, Wire wire) throws ContainerException {
        File location = this.resolve(target.getLocation());
        location.mkdirs();
        ReferenceAdapter adapter = this.getAdaptor(target);
        FileSystemInterceptor interceptor = new FileSystemInterceptor(location, adapter);
        for (InvocationChain chain : wire.getInvocationChains()) {
            chain.addInterceptor((Interceptor)interceptor);
        }
    }

    public void detach(PhysicalWireSourceDefinition source, FileBindingWireTargetDefinition target) throws ContainerException {
    }

    public ObjectFactory<?> createObjectFactory(FileBindingWireTargetDefinition target) throws ContainerException {
        throw new UnsupportedOperationException();
    }

    private File resolve(String location) {
        File file = new File(location);
        if (file.isAbsolute()) {
            return file;
        }
        return new File(this.baseDir, location);
    }

    private ReferenceAdapter getAdaptor(FileBindingWireTargetDefinition source) throws ContainerException {
        String adapterClass = source.getAdapterClass();
        if (adapterClass == null) {
            URI adapterUri = source.getAdapterUri();
            if (adapterUri == null) {
                return ADAPTER;
            }
            Component component = this.manager.getComponent(adapterUri);
            if (component == null) {
                throw new ContainerException("Binding adaptor component not found: " + adapterUri);
            }
            if (!(component instanceof AtomicComponent)) {
                throw new ContainerException("Adaptor component must implement " + AtomicComponent.class.getName() + ": " + adapterUri);
            }
            return new ReferenceAdaptorWrapper((AtomicComponent)component);
        }
        URI uri = source.getClassLoaderId();
        ClassLoader loader = this.registry.getClassLoader(uri);
        if (loader == null) {
            throw new ContainerException("ClassLoader not found: " + uri);
        }
        try {
            return (ReferenceAdapter)loader.loadClass(adapterClass).newInstance();
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException e) {
            throw new ContainerException((Throwable)e);
        }
    }
}

