/*
 * Decompiled with CFR 0.152.
 */
package org.fabric3.binding.file.introspection;

import java.lang.annotation.Annotation;
import java.lang.reflect.AccessibleObject;
import org.fabric3.api.binding.file.annotation.FileBinding;
import org.fabric3.api.binding.file.annotation.Strategy;
import org.fabric3.api.binding.file.model.FileBindingDefinition;
import org.fabric3.api.host.failure.ValidationFailure;
import org.fabric3.api.model.type.component.AbstractService;
import org.fabric3.api.model.type.component.BindingDefinition;
import org.fabric3.api.model.type.component.ReferenceDefinition;
import org.fabric3.api.model.type.java.InjectingComponentType;
import org.fabric3.spi.introspection.IntrospectionContext;
import org.fabric3.spi.introspection.java.AbstractBindingPostProcessor;
import org.fabric3.spi.introspection.java.InvalidAnnotation;
import org.oasisopen.sca.annotation.EagerInit;

@EagerInit
public class FileBindingPostProcessor
extends AbstractBindingPostProcessor<FileBinding> {
    public FileBindingPostProcessor() {
        super(FileBinding.class);
    }

    protected BindingDefinition processService(FileBinding annotation, AbstractService<?> service, InjectingComponentType componentType, Class<?> implClass, IntrospectionContext context) {
        return this.createDefinition(annotation, implClass, context);
    }

    protected BindingDefinition processServiceCallback(FileBinding annotation, AbstractService<?> service, InjectingComponentType componentType, Class<?> implClass, IntrospectionContext context) {
        return null;
    }

    protected BindingDefinition processReference(FileBinding annotation, ReferenceDefinition reference, AccessibleObject object, Class<?> implClass, IntrospectionContext context) {
        return this.createDefinition(annotation, implClass, context);
    }

    protected BindingDefinition processReferenceCallback(FileBinding annotation, ReferenceDefinition reference, AccessibleObject object, Class<?> implClass, IntrospectionContext context) {
        return null;
    }

    private FileBindingDefinition createDefinition(FileBinding annotation, Class<?> implClass, IntrospectionContext context) {
        String location;
        String name = annotation.name();
        if (name.isEmpty()) {
            name = "FileBinding";
        }
        if ((location = annotation.location()).isEmpty()) {
            InvalidAnnotation error = new InvalidAnnotation("File binding annotation must specify a location", implClass, (Annotation)annotation, implClass);
            context.addError((ValidationFailure)error);
        }
        Strategy strategy = annotation.strategy();
        String archiveLocation = this.getNullibleValue(annotation.archiveLocation());
        if (strategy == Strategy.ARCHIVE && archiveLocation == null) {
            InvalidAnnotation error = new InvalidAnnotation("File binding annotation must specify an archive location", implClass, (Annotation)annotation, implClass);
            context.addError((ValidationFailure)error);
        }
        String errorLocation = this.getNullibleValue(annotation.errorLocation());
        String adapterUri = this.getNullibleValue(annotation.adaptor());
        String pattern = this.getNullibleValue(annotation.pattern());
        long delay = annotation.delay();
        if (delay < -1L) {
            InvalidAnnotation error = new InvalidAnnotation("Invalid delay value specified on file binding", implClass, (Annotation)annotation, implClass);
            context.addError((ValidationFailure)error);
        }
        return new FileBindingDefinition(name, pattern, location, strategy, archiveLocation, errorLocation, null, adapterUri, delay);
    }
}

