/*
 * Decompiled with CFR 0.152.
 */
package org.fabric3.binding.file.runtime.sender;

import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.reflect.Array;
import org.fabric3.api.binding.file.ReferenceAdapter;
import org.fabric3.spi.container.invocation.Message;
import org.fabric3.spi.container.wire.Interceptor;
import org.oasisopen.sca.ServiceRuntimeException;

public class FileSystemInterceptor
implements Interceptor {
    private File outputDirectory;
    private ReferenceAdapter adapter;

    public FileSystemInterceptor(File outputDirectory, ReferenceAdapter adapter) {
        this.outputDirectory = outputDirectory;
        this.adapter = adapter;
    }

    public Message invoke(Message msg) {
        Object body = msg.getBody();
        if (body == null || !body.getClass().isArray()) {
            throw new ServiceRuntimeException("Invalid parameter type: " + body);
        }
        int length = Array.getLength(body);
        if (length != 1) {
            throw new ServiceRuntimeException("Invalid number of parameters: " + length);
        }
        Object element = Array.get(body, 0);
        if (!(element instanceof String)) {
            throw new ServiceRuntimeException("Parameter must be a string: " + element);
        }
        File file = new File(this.outputDirectory, (String)element);
        try {
            OutputStream stream = this.adapter.createOutputStream(file);
            msg.setBody((Object)stream);
            return msg;
        }
        catch (IOException e) {
            throw new ServiceRuntimeException((Throwable)e);
        }
    }

    public void setNext(Interceptor next) {
        throw new IllegalStateException("This interceptor must be the last one in an target interceptor chain");
    }

    public Interceptor getNext() {
        return null;
    }
}

