/*
 * Decompiled with CFR 0.152.
 */
package org.expath.tools.saxon.fun;

import net.sf.saxon.lib.ExtensionFunctionDefinition;
import net.sf.saxon.om.StructuredQName;
import net.sf.saxon.value.SequenceType;
import org.expath.tools.ToolsException;
import org.expath.tools.saxon.fun.Function;
import org.expath.tools.saxon.fun.Param;

public class Definition
extends ExtensionFunctionDefinition {
    private final Function myCall;
    private final StructuredQName myName;
    private final SequenceType myResult;
    private final Param[] myParams;
    private final SequenceType[] myParamTypes;
    private final int myMinArity;
    private final int myMaxArity;

    public Definition(Function call, StructuredQName name, SequenceType result, Param ... params) throws ToolsException {
        this.myCall = call;
        this.myName = name;
        this.myResult = result;
        this.myParams = null == params ? new Param[]{} : params;
        this.myMinArity = this.validateArity(this.myParams);
        this.myMaxArity = this.myParams.length;
        if (this.myMinArity < 0) {
            throw new IllegalArgumentException("Minimum arity cannot be lower than 0: " + this.myMinArity);
        }
        if (this.myMinArity > this.myMaxArity) {
            throw new IllegalArgumentException("Minimum arity cannot be greater than maximum arity: " + this.myMinArity + " > " + this.myMaxArity);
        }
        this.myParamTypes = new SequenceType[this.myParams.length];
        for (int i = 0; i < this.myParams.length; ++i) {
            this.myParamTypes[i] = this.myParams[i].type();
        }
    }

    private int validateArity(Param[] params) throws ToolsException {
        int optional = 0;
        for (Param p : params) {
            boolean opt = p.optional();
            if (!opt && optional > 0) {
                throw new ToolsException("Mandatory parameter after an optional one: " + p.name());
            }
            if (!opt) continue;
            ++optional;
        }
        return params.length - optional;
    }

    public Param[] params() {
        return this.myParams;
    }

    public Param param(int pos) {
        return this.myParams[pos];
    }

    public StructuredQName getFunctionQName() {
        return this.myName;
    }

    public int getMinimumNumberOfArguments() {
        return this.myMinArity;
    }

    public int getMaximumNumberOfArguments() {
        return this.myMaxArity;
    }

    public SequenceType[] getArgumentTypes() {
        return this.myParamTypes;
    }

    public SequenceType getResultType(SequenceType[] types) {
        return this.myResult;
    }

    public Function makeCallExpression() {
        return this.myCall;
    }
}

