/*
 * Decompiled with CFR 0.152.
 */
package org.expath.tools.saxon.model;

import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.value.AtomicValue;
import net.sf.saxon.value.BooleanValue;
import net.sf.saxon.value.IntegerValue;
import net.sf.saxon.value.NumericValue;
import org.expath.tools.ToolsException;
import org.expath.tools.model.Attribute;

public class SaxonAttribute
implements Attribute {
    private final NodeInfo myNode;

    public SaxonAttribute(NodeInfo node) {
        this.myNode = node;
    }

    public String getLocalName() {
        return this.myNode.getLocalPart();
    }

    public String getNamespaceUri() {
        return this.myNode.getURI();
    }

    public String getValue() {
        return this.myNode.getStringValue();
    }

    public boolean getBoolean() throws ToolsException {
        AtomicValue val;
        String str = this.myNode.getStringValue();
        try {
            val = BooleanValue.fromString((CharSequence)str).asAtomic();
        }
        catch (XPathException ex) {
            throw new ToolsException("Error parse the attribute value as boolean", (Throwable)ex);
        }
        if (!(val instanceof BooleanValue)) {
            throw new ToolsException("@" + this.getLocalName() + " is not a boolean");
        }
        BooleanValue b = (BooleanValue)val;
        return b.getBooleanValue();
    }

    public int getInteger() throws ToolsException {
        String str = this.myNode.getStringValue();
        NumericValue val = NumericValue.parseNumber((String)str);
        if (NumericValue.isInteger((AtomicValue)val)) {
            throw new ToolsException("@" + this.getLocalName() + " is not an integer");
        }
        IntegerValue i = (IntegerValue)val;
        return i.asBigInteger().intValue();
    }
}

