/*
 * Decompiled with CFR 0.152.
 */
package org.expath.tools.saxon.model;

import javax.xml.stream.XMLStreamException;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.s9api.BuildingStreamWriter;
import net.sf.saxon.s9api.DocumentBuilder;
import net.sf.saxon.s9api.Processor;
import net.sf.saxon.s9api.SaxonApiException;
import org.expath.tools.ToolsException;
import org.expath.tools.model.TreeBuilder;

public class SaxonTreeBuilder
implements TreeBuilder {
    private final BuildingStreamWriter writer;
    private final String myNs;
    private final String myPrefix;

    public SaxonTreeBuilder(XPathContext ctxt, String prefix, String ns) throws ToolsException {
        this.myNs = ns;
        this.myPrefix = prefix;
        try {
            Processor processor = (Processor)ctxt.getConfiguration().getProcessor();
            DocumentBuilder builder = processor.newDocumentBuilder();
            this.writer = builder.newBuildingStreamWriter();
            this.writer.writeStartDocument();
            this.writer.writeNamespace(prefix, ns);
        }
        catch (XMLStreamException | SaxonApiException ex) {
            throw new ToolsException("Could not create Saxon builder", ex);
        }
    }

    public NodeInfo getCurrentRoot() throws ToolsException {
        try {
            this.writer.writeEndDocument();
            this.writer.close();
            return this.writer.getDocumentNode().getUnderlyingNode();
        }
        catch (XMLStreamException ex) {
            throw new ToolsException("Error closing the Saxon tree builder", (Throwable)ex);
        }
        catch (SaxonApiException ex) {
            throw new ToolsException("Error getting root node", (Throwable)ex);
        }
    }

    public void startElem(String localname) throws ToolsException {
        try {
            this.writer.writeStartElement(this.myPrefix, localname, this.myNs);
        }
        catch (XMLStreamException ex) {
            throw new ToolsException("Error starting element on the Saxon tree builder", (Throwable)ex);
        }
    }

    public void attribute(String localname, CharSequence value) throws ToolsException {
        try {
            this.writer.writeAttribute(localname, (String)value);
        }
        catch (XMLStreamException ex) {
            throw new ToolsException("Error creating attribute on the Saxon tree builder", (Throwable)ex);
        }
    }

    public void startContent() throws ToolsException {
    }

    public void endElem() throws ToolsException {
        try {
            this.writer.writeEndElement();
        }
        catch (XMLStreamException ex) {
            throw new ToolsException("Error ending element on the Saxon tree builder", (Throwable)ex);
        }
    }
}

