/*
 * Decompiled with CFR 0.152.
 */
package org.expath.tools.saxon.fun;

import java.util.HashMap;
import java.util.Map;
import net.sf.saxon.Configuration;
import net.sf.saxon.lib.ExtensionFunctionDefinition;
import net.sf.saxon.om.StructuredQName;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.value.SequenceType;
import org.expath.tools.ToolsException;
import org.expath.tools.saxon.fun.DefBuilder;
import org.expath.tools.saxon.fun.Definition;
import org.expath.tools.saxon.fun.Errors;
import org.expath.tools.saxon.fun.Function;
import org.expath.tools.saxon.fun.Param;

public abstract class Library {
    private final String myNs;
    private final String myPrefix;
    private final Map<StructuredQName, Definition> myDefs;
    private final Errors myErrors;

    protected abstract Function[] functions() throws ToolsException;

    public Library(String ns, String prefix) {
        this.myNs = ns;
        this.myPrefix = prefix;
        this.myDefs = new HashMap<StructuredQName, Definition>();
        this.myErrors = new Errors(this);
    }

    public String getNamespace() {
        return this.myNs;
    }

    public String getPrefix() {
        return this.myPrefix;
    }

    public Errors getErrors() {
        return this.myErrors;
    }

    public DefBuilder function(Function call, String local_name) throws ToolsException {
        StructuredQName name = new StructuredQName(this.myPrefix, this.myNs, local_name);
        return this.function(call, name);
    }

    public DefBuilder function(Function call, StructuredQName name) throws ToolsException {
        return new DefBuilder(call, name, this);
    }

    public Definition function(Function call, String local_name, SequenceType result, Param ... params) throws ToolsException {
        StructuredQName name = new StructuredQName(this.myPrefix, this.myNs, local_name);
        return this.function(call, name, result, params);
    }

    public Definition function(Function call, StructuredQName name, SequenceType result, Param ... params) throws ToolsException {
        Definition def = new Definition(call, name, result, params);
        this.addDef(name, def);
        return def;
    }

    public void register(Configuration config) throws ToolsException {
        for (Function f : this.functions()) {
            Definition def = f.definition();
            config.registerExtensionFunction((ExtensionFunctionDefinition)def);
        }
    }

    void addDef(StructuredQName name, Definition def) throws ToolsException {
        if (this.myDefs.containsKey(name)) {
            throw new ToolsException("Library already contains function: " + name);
        }
        this.myDefs.put(name, def);
    }

    public XPathException error(String code, String msg) {
        return this.myErrors.make(code, msg);
    }

    public XPathException error(String code, String msg, Throwable ex) {
        return this.myErrors.make(code, msg, ex);
    }
}

