/*
 * Decompiled with CFR 0.152.
 */
package org.expath.tools.saxon.model;

import java.io.OutputStream;
import java.util.Properties;
import javax.xml.namespace.QName;
import net.sf.saxon.Configuration;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.query.QueryResult;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.tree.iter.SingletonIterator;
import net.sf.saxon.tree.iter.UnfailingIterator;
import org.expath.tools.ToolsException;
import org.expath.tools.model.Sequence;
import org.expath.tools.serial.SerialParameters;

public class SaxonSequence
implements Sequence {
    private final SequenceIterator myIt;
    private final XPathContext myCtxt;

    public SaxonSequence(SequenceIterator it, XPathContext ctxt) {
        this.myIt = it;
        this.myCtxt = ctxt;
    }

    public boolean isEmpty() throws ToolsException {
        try {
            return this.myIt == null || this.myIt.getAnother().next() == null;
        }
        catch (XPathException ex) {
            throw new ToolsException("Error getting another iterator", (Throwable)ex);
        }
    }

    public Sequence next() throws ToolsException {
        Item item;
        try {
            item = this.myIt == null ? null : this.myIt.next();
        }
        catch (XPathException ex) {
            throw new ToolsException("Error getting the next item in the sequence", (Throwable)ex);
        }
        UnfailingIterator it = SingletonIterator.makeIterator((Item)item);
        return new SaxonSequence((SequenceIterator)it, this.myCtxt);
    }

    public void serialize(OutputStream out, SerialParameters params) throws ToolsException {
        Properties props = params == null ? null : this.makeOutputProperties(params);
        Configuration config = this.myCtxt.getConfiguration();
        try {
            QueryResult.serializeSequence((SequenceIterator)this.myIt, (Configuration)config, (OutputStream)out, (Properties)props);
        }
        catch (XPathException ex) {
            throw new ToolsException("Error serializing the sequence", (Throwable)ex);
        }
    }

    private Properties makeOutputProperties(SerialParameters params) throws ToolsException {
        Properties props = new Properties();
        this.setOutputKey(props, "method", params.getMethod());
        this.setOutputKey(props, "media-type", params.getMediaType());
        this.setOutputKey(props, "encoding", params.getEncoding());
        this.setOutputKey(props, "cdata-section-elements", params.getCdataSectionElements());
        this.setOutputKey(props, "doctype-public", params.getDoctypePublic());
        this.setOutputKey(props, "doctype-system", params.getDoctypeSystem());
        this.setOutputKey(props, "indent", params.getIndent());
        this.setOutputKey(props, "omit-xml-declaration", params.getOmitXmlDeclaration());
        this.setOutputKey(props, "standalone", params.getStandalone());
        this.setOutputKey(props, "version", params.getVersion());
        this.setOutputKey(props, "byte-order-mark", params.getByteOrderMark());
        this.setOutputKey(props, "escape-uri-attributes", params.getEscapeUriAttributes());
        this.setOutputKey(props, "include-content-type", params.getIncludeContentType());
        this.setOutputKey(props, "normalization-form", params.getNormalizationForm());
        this.setOutputKey(props, "undeclare-prefixes", params.getUndeclarePrefixes());
        if (params.getUseCharacterMaps() != null) {
            throw new ToolsException("Use character map serialization parameter is not supported");
        }
        this.setExtensionKey(props, params, "{http://saxon.sf.net/}character-representation");
        this.setExtensionKey(props, params, "{http://saxon.sf.net/}double-space");
        this.setExtensionKey(props, params, "{http://saxon.sf.net/}indent-spaces");
        this.setExtensionKey(props, params, "{http://saxon.sf.net/}line-length");
        this.setExtensionKey(props, params, "{http://saxon.sf.net/}recognize-binary");
        this.setExtensionKey(props, params, "{http://saxon.sf.net/}require-well-formed");
        this.setExtensionKey(props, params, "{http://saxon.sf.net/}stylesheet-version");
        this.setExtensionKey(props, params, "suppress-indentation");
        this.setExtensionKey(props, params, "{http://saxon.sf.net/}wrap-result-sequence");
        return props;
    }

    private QName parseClarkNotation(String clark) {
        if (clark.startsWith("{")) {
            int idx = clark.indexOf(125);
            String uri = clark.substring(1, idx);
            String local = clark.substring(idx + 1);
            return new QName(uri, local);
        }
        return new QName(clark);
    }

    private void setExtensionKey(Properties props, SerialParameters params, String name) throws ToolsException {
        QName qname = this.parseClarkNotation(name);
        String value = params.getExtension(qname);
        if (value != null) {
            props.setProperty(name, value);
        }
    }

    private void setOutputKey(Properties props, String name, String value) throws ToolsException {
        if (value != null) {
            props.setProperty(name, value);
        }
    }

    private void setOutputKey(Properties props, String name, Boolean value) throws ToolsException {
        if (value != null) {
            props.setProperty(name, value != false ? "yes" : "no");
        }
    }

    private void setOutputKey(Properties props, String name, SerialParameters.Standalone value) throws ToolsException {
        if (value != null) {
            switch (value) {
                case YES: {
                    props.setProperty(name, "yes");
                    break;
                }
                case NO: {
                    props.setProperty(name, "no");
                    break;
                }
                case OMIT: {
                    props.setProperty(name, "omit");
                    break;
                }
                default: {
                    throw new ToolsException("Invalid Standalone value: " + value);
                }
            }
        }
    }

    private void setOutputKey(Properties props, String name, QName value) throws ToolsException {
        if (value != null) {
            if (value.getNamespaceURI() != null) {
                throw new ToolsException("A QName with a non-null namespace not supported as a serialization param: {" + value.getNamespaceURI() + "}" + value.getLocalPart());
            }
            props.setProperty(name, value.getLocalPart());
        }
    }

    private void setOutputKey(Properties props, String name, Iterable<QName> value) throws ToolsException {
        if (value != null) {
            StringBuilder buf = new StringBuilder();
            for (QName qname : value) {
                if (qname.getNamespaceURI() != null) {
                    throw new ToolsException("A QName with a non-null namespace not supported as a serialization param: {" + qname.getNamespaceURI() + "}" + qname.getLocalPart());
                }
                buf.append(qname.getLocalPart());
                buf.append(" ");
            }
            props.setProperty(name, buf.toString());
        }
    }
}

