/*
 * Decompiled with CFR 0.152.
 */
package org.expath.tools.saxon.fun;

import net.sf.saxon.lib.ExtensionFunctionCall;
import net.sf.saxon.om.Sequence;
import net.sf.saxon.trans.XPathException;
import org.expath.tools.ToolsException;
import org.expath.tools.saxon.fun.Definition;
import org.expath.tools.saxon.fun.Library;
import org.expath.tools.saxon.fun.Parameters;

public abstract class Function
extends ExtensionFunctionCall {
    private final Library myLib;
    private Definition myDef = null;

    protected abstract Definition makeDefinition() throws ToolsException;

    public Function(Library lib) {
        this.myLib = lib;
    }

    public Library library() {
        return this.myLib;
    }

    public Definition definition() throws ToolsException {
        if (null == this.myDef) {
            this.myDef = this.makeDefinition();
        }
        return this.myDef;
    }

    public Parameters checkParams(Sequence[] params) throws XPathException {
        try {
            Definition def = this.definition();
            return new Parameters(this.myLib, params, def.getMinimumNumberOfArguments(), def.params());
        }
        catch (ToolsException ex) {
            throw new XPathException("Error instantiating the function definition", (Throwable)ex);
        }
    }
}

