/*
 * Decompiled with CFR 0.152.
 */
package org.esigate.jsf;

import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import javax.faces.el.ValueBinding;

public class UIComponentUtils {
    public static Boolean getParam(UIComponent uiComponent, String name, Boolean currentValue) {
        if (currentValue != null) {
            return currentValue;
        }
        FacesContext facesContext = FacesContext.getCurrentInstance();
        ValueBinding valueBinding = uiComponent.getValueBinding(name);
        if (valueBinding != null) {
            return Boolean.valueOf((String)valueBinding.getValue(facesContext));
        }
        return null;
    }

    public static final String getParam(UIComponent uiComponent, String name, String currentValue) {
        if (currentValue != null) {
            return currentValue;
        }
        FacesContext facesContext = FacesContext.getCurrentInstance();
        ValueBinding valueBinding = uiComponent.getValueBinding(name);
        if (valueBinding != null) {
            return (String)valueBinding.getValue(facesContext);
        }
        return null;
    }

    public static final void renderChild(UIComponent child) throws IOException {
        if (!child.isRendered()) {
            return;
        }
        FacesContext facesContext = FacesContext.getCurrentInstance();
        child.encodeBegin(facesContext);
        if (child.getRendersChildren()) {
            child.encodeChildren(facesContext);
        } else {
            UIComponentUtils.renderChildren(child);
        }
        child.encodeEnd(facesContext);
    }

    public static final void renderChildren(UIComponent component) throws IOException {
        if (component.getChildCount() > 0) {
            for (UIComponent child : component.getChildren()) {
                UIComponentUtils.renderChild(child);
            }
        }
    }

    public static final String renderChildrenToString(UIComponent component) throws IOException {
        FacesContext facesContext = FacesContext.getCurrentInstance();
        ResponseWriter initialWriter = facesContext.getResponseWriter();
        StringWriter stringWriter = new StringWriter();
        ResponseWriter newWriter = initialWriter.cloneWithWriter((Writer)stringWriter);
        facesContext.setResponseWriter(newWriter);
        UIComponentUtils.renderChildren(component);
        facesContext.setResponseWriter(initialWriter);
        return stringWriter.toString();
    }
}

