/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.security.rest.action.service;

import java.io.IOException;
import java.util.List;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.ActionType;
import org.elasticsearch.action.support.WriteRequest;
import org.elasticsearch.client.internal.node.NodeClient;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.UUIDs;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.license.XPackLicenseState;
import org.elasticsearch.rest.BaseRestHandler;
import org.elasticsearch.rest.RestHandler;
import org.elasticsearch.rest.RestRequest;
import org.elasticsearch.rest.action.RestToXContentListener;
import org.elasticsearch.xpack.core.security.action.service.CreateServiceAccountTokenAction;
import org.elasticsearch.xpack.core.security.action.service.CreateServiceAccountTokenRequest;
import org.elasticsearch.xpack.security.rest.action.SecurityBaseRestHandler;

public class RestCreateServiceAccountTokenAction
extends SecurityBaseRestHandler {
    public RestCreateServiceAccountTokenAction(Settings settings, XPackLicenseState licenseState) {
        super(settings, licenseState);
    }

    public List<RestHandler.Route> routes() {
        return List.of(new RestHandler.Route(RestRequest.Method.POST, "/_security/service/{namespace}/{service}/credential/token/{name}"), new RestHandler.Route(RestRequest.Method.PUT, "/_security/service/{namespace}/{service}/credential/token/{name}"), new RestHandler.Route(RestRequest.Method.POST, "/_security/service/{namespace}/{service}/credential/token"));
    }

    public String getName() {
        return "xpack_security_create_service_account_token";
    }

    @Override
    protected BaseRestHandler.RestChannelConsumer innerPrepareRequest(RestRequest request, NodeClient client) throws IOException {
        Object tokenName = request.param("name");
        if (Strings.isNullOrEmpty((String)tokenName)) {
            tokenName = "token_" + UUIDs.base64UUID();
        }
        CreateServiceAccountTokenRequest createServiceAccountTokenRequest = new CreateServiceAccountTokenRequest(request.param("namespace"), request.param("service"), (String)tokenName);
        String refreshPolicy = request.param("refresh");
        if (refreshPolicy != null) {
            createServiceAccountTokenRequest.setRefreshPolicy(WriteRequest.RefreshPolicy.parse((String)refreshPolicy));
        }
        return channel -> client.execute((ActionType)CreateServiceAccountTokenAction.INSTANCE, (ActionRequest)createServiceAccountTokenRequest, (ActionListener)new RestToXContentListener(channel));
    }
}

