/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.security.support;

import java.util.Iterator;
import java.util.function.Consumer;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.search.aggregations.AggregationBuilder;
import org.elasticsearch.search.aggregations.AggregatorFactories;
import org.elasticsearch.search.aggregations.PipelineAggregationBuilder;
import org.elasticsearch.search.aggregations.bucket.composite.CompositeAggregationBuilder;
import org.elasticsearch.search.aggregations.bucket.composite.CompositeValuesSourceBuilder;
import org.elasticsearch.search.aggregations.bucket.filter.FilterAggregationBuilder;
import org.elasticsearch.search.aggregations.bucket.filter.FiltersAggregationBuilder;
import org.elasticsearch.search.aggregations.bucket.filter.FiltersAggregator;
import org.elasticsearch.search.aggregations.bucket.missing.MissingAggregationBuilder;
import org.elasticsearch.search.aggregations.bucket.range.DateRangeAggregationBuilder;
import org.elasticsearch.search.aggregations.bucket.range.RangeAggregationBuilder;
import org.elasticsearch.search.aggregations.bucket.terms.TermsAggregationBuilder;
import org.elasticsearch.search.aggregations.metrics.CardinalityAggregationBuilder;
import org.elasticsearch.search.aggregations.metrics.ValueCountAggregationBuilder;
import org.elasticsearch.search.aggregations.support.ValuesSourceAggregationBuilder;
import org.elasticsearch.xpack.security.support.FieldNameTranslators;

public class ApiKeyAggregationsBuilder {
    public static AggregatorFactories.Builder process(@Nullable AggregatorFactories.Builder aggsBuilder, @Nullable Consumer<String> fieldNameVisitor) {
        if (aggsBuilder == null) {
            return null;
        }
        Iterator iterator = aggsBuilder.getPipelineAggregatorFactories().iterator();
        if (iterator.hasNext()) {
            PipelineAggregationBuilder pipelineAggregator = (PipelineAggregationBuilder)iterator.next();
            throw new IllegalArgumentException("Unsupported aggregation of type [" + pipelineAggregator.getType() + "]");
        }
        AggregatorFactories.Builder copiedAggsBuilder = AggregatorFactories.builder();
        for (AggregationBuilder aggregationBuilder : aggsBuilder.getAggregatorFactories()) {
            copiedAggsBuilder.addAggregator(ApiKeyAggregationsBuilder.translateAggsFields(aggregationBuilder, fieldNameVisitor != null ? fieldNameVisitor : ignored -> {}));
        }
        return copiedAggsBuilder;
    }

    private static AggregationBuilder translateAggsFields(AggregationBuilder aggsBuilder, Consumer<String> fieldNameVisitor) {
        return AggregationBuilder.deepCopy((AggregationBuilder)aggsBuilder, copiedAggsBuilder -> {
            Iterator iterator = copiedAggsBuilder.getPipelineAggregations().iterator();
            if (iterator.hasNext()) {
                PipelineAggregationBuilder pipelineAggregator = (PipelineAggregationBuilder)iterator.next();
                throw new IllegalArgumentException("Unsupported aggregation of type [" + pipelineAggregator.getType() + "]");
            }
            if (copiedAggsBuilder instanceof ValuesSourceAggregationBuilder) {
                ValuesSourceAggregationBuilder valuesSourceAggregationBuilder = (ValuesSourceAggregationBuilder)copiedAggsBuilder;
                if (!(valuesSourceAggregationBuilder instanceof TermsAggregationBuilder || valuesSourceAggregationBuilder instanceof RangeAggregationBuilder || valuesSourceAggregationBuilder instanceof DateRangeAggregationBuilder || valuesSourceAggregationBuilder instanceof MissingAggregationBuilder || valuesSourceAggregationBuilder instanceof CardinalityAggregationBuilder || valuesSourceAggregationBuilder instanceof ValueCountAggregationBuilder)) {
                    throw new IllegalArgumentException("Unsupported API Keys agg [" + copiedAggsBuilder.getName() + "] of type [" + copiedAggsBuilder.getType() + "]");
                }
                if (valuesSourceAggregationBuilder.script() != null) {
                    throw new IllegalArgumentException("Unsupported script value source for [" + copiedAggsBuilder.getName() + "] agg");
                }
                String translatedFieldName = FieldNameTranslators.API_KEY_FIELD_NAME_TRANSLATORS.translate(valuesSourceAggregationBuilder.field());
                valuesSourceAggregationBuilder.field(translatedFieldName);
                fieldNameVisitor.accept(translatedFieldName);
                return valuesSourceAggregationBuilder;
            }
            if (copiedAggsBuilder instanceof CompositeAggregationBuilder) {
                CompositeAggregationBuilder compositeAggregationBuilder = (CompositeAggregationBuilder)copiedAggsBuilder;
                for (CompositeValuesSourceBuilder valueSource : compositeAggregationBuilder.sources()) {
                    if (valueSource.script() != null) {
                        throw new IllegalArgumentException("Unsupported script value source for [" + valueSource.name() + "] of composite agg [" + compositeAggregationBuilder.getName() + "]");
                    }
                    String translatedFieldName = FieldNameTranslators.API_KEY_FIELD_NAME_TRANSLATORS.translate(valueSource.field());
                    valueSource.field(translatedFieldName);
                    fieldNameVisitor.accept(translatedFieldName);
                }
                return compositeAggregationBuilder;
            }
            if (copiedAggsBuilder instanceof FilterAggregationBuilder) {
                FilterAggregationBuilder filterAggregationBuilder = (FilterAggregationBuilder)copiedAggsBuilder;
                FilterAggregationBuilder newFilterAggregationBuilder = new FilterAggregationBuilder(filterAggregationBuilder.getName(), FieldNameTranslators.API_KEY_FIELD_NAME_TRANSLATORS.translateQueryBuilderFields(filterAggregationBuilder.getFilter(), fieldNameVisitor));
                if (filterAggregationBuilder.getMetadata() != null) {
                    newFilterAggregationBuilder.setMetadata(filterAggregationBuilder.getMetadata());
                }
                for (AggregationBuilder subAgg : filterAggregationBuilder.getSubAggregations()) {
                    newFilterAggregationBuilder.subAggregation(subAgg);
                }
                return newFilterAggregationBuilder;
            }
            if (copiedAggsBuilder instanceof FiltersAggregationBuilder) {
                FiltersAggregationBuilder newFiltersAggregationBuilder;
                FiltersAggregationBuilder filtersAggregationBuilder = (FiltersAggregationBuilder)copiedAggsBuilder;
                QueryBuilder[] filterQueryBuilders = new QueryBuilder[filtersAggregationBuilder.filters().size()];
                for (int i = 0; i < filtersAggregationBuilder.filters().size(); ++i) {
                    filterQueryBuilders[i] = FieldNameTranslators.API_KEY_FIELD_NAME_TRANSLATORS.translateQueryBuilderFields(((FiltersAggregator.KeyedFilter)filtersAggregationBuilder.filters().get(i)).filter(), fieldNameVisitor);
                }
                if (filtersAggregationBuilder.isKeyed()) {
                    FiltersAggregator.KeyedFilter[] keyedFilters = new FiltersAggregator.KeyedFilter[filterQueryBuilders.length];
                    for (int i = 0; i < keyedFilters.length; ++i) {
                        keyedFilters[i] = new FiltersAggregator.KeyedFilter(((FiltersAggregator.KeyedFilter)filtersAggregationBuilder.filters().get(i)).key(), filterQueryBuilders[i]);
                    }
                    newFiltersAggregationBuilder = new FiltersAggregationBuilder(filtersAggregationBuilder.getName(), keyedFilters);
                } else {
                    newFiltersAggregationBuilder = new FiltersAggregationBuilder(filtersAggregationBuilder.getName(), filterQueryBuilders);
                }
                assert (newFiltersAggregationBuilder.isKeyed() == filtersAggregationBuilder.isKeyed());
                newFiltersAggregationBuilder.otherBucket(filtersAggregationBuilder.otherBucket()).otherBucketKey(filtersAggregationBuilder.otherBucketKey()).keyedBucket(filtersAggregationBuilder.keyedBucket());
                for (AggregationBuilder subAgg : filtersAggregationBuilder.getSubAggregations()) {
                    newFiltersAggregationBuilder.subAggregation(subAgg);
                }
                return newFiltersAggregationBuilder;
            }
            throw new IllegalArgumentException("Unsupported API Keys agg [" + copiedAggsBuilder.getName() + "] of type [" + copiedAggsBuilder.getType() + "]");
        });
    }
}

