/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.security.rest.action.rolemapping;

import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.ElasticsearchStatusException;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.license.XPackLicenseState;
import org.elasticsearch.rest.RestRequest;
import org.elasticsearch.rest.RestStatus;
import org.elasticsearch.xpack.security.rest.action.SecurityBaseRestHandler;

abstract class NativeRoleMappingBaseRestHandler
extends SecurityBaseRestHandler {
    private static final Logger logger = LogManager.getLogger(NativeRoleMappingBaseRestHandler.class);

    NativeRoleMappingBaseRestHandler(Settings settings, XPackLicenseState licenseState) {
        super(settings, licenseState);
    }

    @Override
    protected Exception innerCheckFeatureAvailable(RestRequest request) {
        Boolean nativeRoleMappingsEnabled = this.settings.getAsBoolean("xpack.security.authc.native_role_mappings.enabled", Boolean.valueOf(true));
        if (!nativeRoleMappingsEnabled.booleanValue()) {
            logger.debug("Attempt to call [{} {}] but [{}] is [{}]", (Object)request.method(), (Object)request.rawPath(), (Object)"xpack.security.authc.native_role_mappings.enabled", (Object)this.settings.get("xpack.security.authc.native_role_mappings.enabled"));
            return new ElasticsearchStatusException("Native role mapping management is not enabled in this Elasticsearch instance", RestStatus.GONE, new Object[0]);
        }
        return null;
    }
}

