/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.security.action.user;

import java.util.concurrent.Executor;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionRequestValidationException;
import org.elasticsearch.action.ValidateActions;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.action.support.HandledTransportAction;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.util.concurrent.EsExecutors;
import org.elasticsearch.injection.guice.Inject;
import org.elasticsearch.tasks.Task;
import org.elasticsearch.transport.TransportService;
import org.elasticsearch.xpack.core.security.SecurityContext;
import org.elasticsearch.xpack.core.security.action.user.PutUserRequest;
import org.elasticsearch.xpack.core.security.action.user.PutUserResponse;
import org.elasticsearch.xpack.core.security.authc.Subject;
import org.elasticsearch.xpack.core.security.authc.esnative.ClientReservedRealm;
import org.elasticsearch.xpack.core.security.support.NativeRealmValidationUtil;
import org.elasticsearch.xpack.core.security.support.Validation;
import org.elasticsearch.xpack.core.security.user.AnonymousUser;
import org.elasticsearch.xpack.security.authc.esnative.NativeUsersStore;

public class TransportPutUserAction
extends HandledTransportAction<PutUserRequest, PutUserResponse> {
    private final Settings settings;
    private final NativeUsersStore usersStore;
    private final SecurityContext securityContext;

    @Inject
    public TransportPutUserAction(Settings settings, ActionFilters actionFilters, NativeUsersStore usersStore, SecurityContext securityContext, TransportService transportService) {
        super("cluster:admin/xpack/security/user/put", transportService, actionFilters, PutUserRequest::new, (Executor)EsExecutors.DIRECT_EXECUTOR_SERVICE);
        this.settings = settings;
        this.usersStore = usersStore;
        this.securityContext = securityContext;
    }

    protected void doExecute(Task task, final PutUserRequest request, final ActionListener<PutUserResponse> listener) {
        ActionRequestValidationException validationException = this.validateRequest(request);
        if (validationException != null) {
            listener.onFailure((Exception)validationException);
        } else {
            this.usersStore.putUser(request, new ActionListener<Boolean>(){

                public void onResponse(Boolean created) {
                    if (created.booleanValue()) {
                        TransportPutUserAction.this.logger.info("added user [{}]", (Object)request.username());
                    } else {
                        TransportPutUserAction.this.logger.info("updated user [{}]", (Object)request.username());
                    }
                    listener.onResponse((Object)new PutUserResponse(created.booleanValue()));
                }

                public void onFailure(Exception e) {
                    TransportPutUserAction.this.logger.error(() -> "failed to put user [" + request.username() + "]", (Throwable)e);
                    listener.onFailure(e);
                }
            });
        }
    }

    private ActionRequestValidationException validateRequest(PutUserRequest request) {
        ActionRequestValidationException validationException = null;
        String username = request.username();
        if (this.isDisablingOwnUser(request)) {
            validationException = ValidateActions.addValidationError((String)"native and reserved realm users may not update the enabled status of their own account", validationException);
        }
        if (ClientReservedRealm.isReserved((String)username, (Settings)this.settings)) {
            validationException = AnonymousUser.isAnonymousUsername((String)username, (Settings)this.settings) ? ValidateActions.addValidationError((String)("user [" + username + "] is anonymous and cannot be modified via the API"), (ActionRequestValidationException)validationException) : ValidateActions.addValidationError((String)("user [" + username + "] is reserved and only the password can be changed"), (ActionRequestValidationException)validationException);
        } else {
            Validation.Error usernameError = NativeRealmValidationUtil.validateUsername((String)username, (boolean)true, (Settings)this.settings);
            if (usernameError != null) {
                validationException = ValidateActions.addValidationError((String)usernameError.toString(), (ActionRequestValidationException)validationException);
            }
        }
        if (request.roles() != null) {
            for (String role : request.roles()) {
                Validation.Error roleNameError = NativeRealmValidationUtil.validateRoleName((String)role, (boolean)true);
                if (roleNameError == null) continue;
                validationException = ValidateActions.addValidationError((String)roleNameError.toString(), (ActionRequestValidationException)validationException);
            }
        }
        return validationException;
    }

    private boolean isDisablingOwnUser(PutUserRequest request) {
        if (!request.enabled()) {
            Subject effectiveSubject = this.securityContext.getAuthentication().getEffectiveSubject();
            String realmType = effectiveSubject.getRealm().getType();
            return "native".equals(realmType) && effectiveSubject.getUser().principal().equals(request.username());
        }
        return false;
    }
}

