/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.security;

import org.elasticsearch.Version;
import org.elasticsearch.bootstrap.BootstrapCheck;
import org.elasticsearch.bootstrap.BootstrapContext;
import org.elasticsearch.common.ReferenceDocs;
import org.elasticsearch.common.VersionId;
import org.elasticsearch.env.NodeMetadata;
import org.elasticsearch.license.ClusterStateLicenseService;
import org.elasticsearch.license.License;
import org.elasticsearch.license.LicenseService;
import org.elasticsearch.xpack.core.XPackSettings;

public class SecurityImplicitBehaviorBootstrapCheck
implements BootstrapCheck {
    private final NodeMetadata nodeMetadata;
    private final LicenseService licenseService;

    public SecurityImplicitBehaviorBootstrapCheck(NodeMetadata nodeMetadata, LicenseService licenseService) {
        this.nodeMetadata = nodeMetadata;
        this.licenseService = licenseService;
    }

    public BootstrapCheck.BootstrapCheckResult check(BootstrapContext context) {
        if (this.nodeMetadata == null) {
            return BootstrapCheck.BootstrapCheckResult.success();
        }
        LicenseService licenseService = this.licenseService;
        if (licenseService instanceof ClusterStateLicenseService) {
            ClusterStateLicenseService clusterStateLicenseService = (ClusterStateLicenseService)licenseService;
            License license = clusterStateLicenseService.getLicense(context.metadata());
            Version lastKnownVersion = this.nodeMetadata.previousNodeVersion().toVersion();
            if (lastKnownVersion.before((VersionId)Version.V_8_0_0) && !XPackSettings.SECURITY_ENABLED.exists(context.settings()) && (license.operationMode() == License.OperationMode.BASIC || license.operationMode() == License.OperationMode.TRIAL)) {
                return BootstrapCheck.BootstrapCheckResult.failure((String)("The default value for [" + XPackSettings.SECURITY_ENABLED.getKey() + "] has changed in the current version.  Security features were implicitly disabled for this node but they would now be enabled, possibly preventing access to the node. See " + String.valueOf(this.referenceDocs()) + " to configure security, or explicitly disable security by setting [xpack.security.enabled] to \"false\" in elasticsearch.yml before restarting the node."));
            }
        }
        return BootstrapCheck.BootstrapCheckResult.success();
    }

    public boolean alwaysEnforce() {
        return true;
    }

    public ReferenceDocs referenceDocs() {
        return ReferenceDocs.BOOTSTRAP_CHECK_SECURITY_MINIMAL_SETUP;
    }
}

