/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.security.authz;

import java.io.IOException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.lucene.util.SetOnce;
import org.elasticsearch.common.CheckedBiConsumer;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.license.XPackLicenseState;
import org.elasticsearch.script.ScriptService;
import org.elasticsearch.search.internal.ShardSearchRequest;
import org.elasticsearch.xpack.core.security.SecurityContext;
import org.elasticsearch.xpack.core.security.SecurityField;
import org.elasticsearch.xpack.core.security.authz.accesscontrol.IndicesAccessControl;
import org.elasticsearch.xpack.core.security.authz.support.SecurityQueryTemplateEvaluator;
import org.elasticsearch.xpack.core.security.user.User;

public class DlsFlsRequestCacheDifferentiator
implements CheckedBiConsumer<ShardSearchRequest, StreamOutput, IOException> {
    private static final Logger logger = LogManager.getLogger(DlsFlsRequestCacheDifferentiator.class);
    private final XPackLicenseState licenseState;
    private final SetOnce<SecurityContext> securityContextHolder;
    private final SetOnce<ScriptService> scriptServiceReference;

    public DlsFlsRequestCacheDifferentiator(XPackLicenseState licenseState, SetOnce<SecurityContext> securityContextReference, SetOnce<ScriptService> scriptServiceReference) {
        this.licenseState = licenseState;
        this.securityContextHolder = securityContextReference;
        this.scriptServiceReference = scriptServiceReference;
    }

    public void accept(ShardSearchRequest request, StreamOutput out) throws IOException {
        String indexName;
        SecurityContext securityContext = (SecurityContext)this.securityContextHolder.get();
        IndicesAccessControl indicesAccessControl = (IndicesAccessControl)securityContext.getThreadContext().getTransient("_indices_permissions");
        IndicesAccessControl.IndexAccessControl indexAccessControl = indicesAccessControl.getIndexPermissions(indexName = request.shardId().getIndexName());
        if (indexAccessControl != null && (indexAccessControl.getFieldPermissions().hasFieldLevelSecurity() || indexAccessControl.getDocumentPermissions().hasDocumentLevelPermissions()) && SecurityField.DOCUMENT_LEVEL_SECURITY_FEATURE.checkWithoutTracking(this.licenseState)) {
            logger.debug("index [{}] with field level access controls [{}] document level access controls [{}]. Differentiating request cache key", (Object)indexName, (Object)indexAccessControl.getFieldPermissions().hasFieldLevelSecurity(), (Object)indexAccessControl.getDocumentPermissions().hasDocumentLevelPermissions());
            indexAccessControl.buildCacheKey(out, SecurityQueryTemplateEvaluator.wrap((User)securityContext.getUser(), (ScriptService)((ScriptService)this.scriptServiceReference.get())));
        }
    }
}

