/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.security.authc.support;

import java.util.ArrayList;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.settings.Setting;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.util.concurrent.ThreadContext;
import org.elasticsearch.core.Tuple;
import org.elasticsearch.license.LicenseUtils;
import org.elasticsearch.license.XPackLicenseState;
import org.elasticsearch.xpack.core.security.authc.AuthenticationResult;
import org.elasticsearch.xpack.core.security.authc.Realm;
import org.elasticsearch.xpack.core.security.authc.RealmConfig;
import org.elasticsearch.xpack.core.security.authc.support.DelegatedAuthorizationSettings;
import org.elasticsearch.xpack.core.security.user.User;
import org.elasticsearch.xpack.security.Security;
import org.elasticsearch.xpack.security.authc.support.RealmUserLookup;

public class DelegatedAuthorizationSupport {
    private final RealmUserLookup lookup;
    private static final Logger logger = LogManager.getLogger(DelegatedAuthorizationSupport.class);
    private final XPackLicenseState licenseState;

    public DelegatedAuthorizationSupport(Iterable<? extends Realm> allRealms, RealmConfig config, XPackLicenseState licenseState) {
        this(allRealms, (List)config.getSetting(DelegatedAuthorizationSettings.AUTHZ_REALMS), config.settings(), config.threadContext(), licenseState);
        if (this.lookup.hasRealms()) {
            logger.info("Realm [{}] is delegating authorization to [{}]", (Object)config.identifier(), (Object)Strings.collectionToCommaDelimitedString(this.lookup.getRealms()));
        }
    }

    protected DelegatedAuthorizationSupport(Iterable<? extends Realm> allRealms, List<String> lookupRealms, Settings settings, ThreadContext threadContext, XPackLicenseState licenseState) {
        List<Realm> resolvedLookupRealms = DelegatedAuthorizationSupport.resolveRealms(allRealms, lookupRealms);
        DelegatedAuthorizationSupport.checkForRealmChains(resolvedLookupRealms, settings);
        this.lookup = new RealmUserLookup(resolvedLookupRealms, threadContext);
        this.licenseState = licenseState;
    }

    public boolean hasDelegation() {
        return this.lookup.hasRealms();
    }

    public void resolve(String username, ActionListener<AuthenticationResult<User>> resultListener) {
        boolean authzOk = Security.DELEGATED_AUTHORIZATION_FEATURE.check(this.licenseState);
        if (!authzOk) {
            resultListener.onResponse((Object)AuthenticationResult.unsuccessful((String)"authorization_realms are not permitted", (Exception)((Object)LicenseUtils.newComplianceException((String)"authorization_realms"))));
            return;
        }
        if (!this.hasDelegation()) {
            resultListener.onResponse((Object)AuthenticationResult.unsuccessful((String)"No [authorization_realms] have been configured", null));
            return;
        }
        ActionListener userListener = ActionListener.wrap(tuple -> {
            if (tuple != null) {
                logger.trace("Found user " + tuple.v1() + " in realm " + tuple.v2());
                resultListener.onResponse((Object)AuthenticationResult.success((Object)((User)tuple.v1())));
            } else {
                resultListener.onResponse((Object)AuthenticationResult.unsuccessful((String)("the principal [" + username + "] was authenticated, but no user could be found in realms [" + Strings.collectionToDelimitedString(this.lookup.getRealms(), (String)",") + "]"), null));
            }
        }, arg_0 -> resultListener.onFailure(arg_0));
        this.lookup.lookup(username, (ActionListener<Tuple<User, Realm>>)userListener);
    }

    private static List<Realm> resolveRealms(Iterable<? extends Realm> allRealms, List<String> lookupRealms) {
        ArrayList<Realm> result = new ArrayList<Realm>(lookupRealms.size());
        for (String name : lookupRealms) {
            result.add(DelegatedAuthorizationSupport.findRealm(name, allRealms));
        }
        assert (result.size() == lookupRealms.size());
        return result;
    }

    private static void checkForRealmChains(Iterable<Realm> delegatedRealms, Settings globalSettings) {
        for (Realm realm : delegatedRealms) {
            Setting realmAuthzSetting = ((Setting.AffixSetting)DelegatedAuthorizationSettings.AUTHZ_REALMS.apply(realm.type())).getConcreteSettingForNamespace(realm.name());
            if (!realmAuthzSetting.exists(globalSettings)) continue;
            throw new IllegalArgumentException("cannot use realm [" + realm + "] as an authorization realm - it is already delegating authorization to [" + realmAuthzSetting.get(globalSettings) + "]");
        }
    }

    private static Realm findRealm(String name, Iterable<? extends Realm> allRealms) {
        for (Realm realm : allRealms) {
            if (!name.equals(realm.name())) continue;
            return realm;
        }
        throw new IllegalArgumentException("configured authorization realm [" + name + "] does not exist (or is not enabled)");
    }

    public String toString() {
        return "security-delegated-authorization: available [" + Security.DELEGATED_AUTHORIZATION_FEATURE.checkWithoutTracking(this.licenseState) + "], lookup-realms [" + Strings.collectionToDelimitedString(this.lookup.getRealms(), (String)",") + "]";
    }
}

