/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.security.authc.jwt;

import com.nimbusds.jose.JWSHeader;
import com.nimbusds.jwt.JWTClaimsSet;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.settings.SettingsException;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.xpack.core.security.support.Automatons;
import org.elasticsearch.xpack.security.authc.jwt.FallbackableClaim;
import org.elasticsearch.xpack.security.authc.jwt.JwtFieldValidator;

public class JwtStringClaimValidator
implements JwtFieldValidator {
    public static final JwtStringClaimValidator ALLOW_ALL_SUBJECTS = new JwtStringClaimValidator("sub", true, List.of(), List.of("*"));
    private final String claimName;
    private final boolean singleValuedClaim;
    @Nullable
    private final Map<String, String> fallbackClaimNames;
    private final Predicate<String> allowedClaimValuesPredicate;

    public JwtStringClaimValidator(String claimName, boolean singleValuedClaim, Collection<String> allowedClaimValues, Collection<String> allowedClaimValuePatterns) {
        this(claimName, singleValuedClaim, null, allowedClaimValues, allowedClaimValuePatterns);
    }

    public JwtStringClaimValidator(final String claimName, boolean singleValuedClaim, Map<String, String> fallbackClaimNames, final Collection<String> allowedClaimValues, final Collection<String> allowedClaimValuePatterns) {
        assert (allowedClaimValues != null) : "allowed claim values should be empty rather than null";
        assert (allowedClaimValuePatterns != null) : "allowed claim value patterns should be empty rather than null";
        this.claimName = claimName;
        this.singleValuedClaim = singleValuedClaim;
        this.fallbackClaimNames = fallbackClaimNames;
        this.allowedClaimValuesPredicate = new Predicate<String>(){
            private final Set<String> allowedClaimsSet;
            private final Predicate<String> allowedClaimPatternsPredicate;
            {
                this.allowedClaimsSet = new HashSet<String>(allowedClaimValues);
                this.allowedClaimPatternsPredicate = JwtStringClaimValidator.predicateFromPatterns(claimName, allowedClaimValuePatterns);
            }

            @Override
            public boolean test(String s) {
                return this.allowedClaimsSet.contains(s) || this.allowedClaimPatternsPredicate.test(s);
            }

            public String toString() {
                return "[" + Strings.collectionToCommaDelimitedString(this.allowedClaimsSet) + "] || [" + this.allowedClaimPatternsPredicate + "]";
            }
        };
    }

    @Override
    public void validate(JWSHeader jwsHeader, JWTClaimsSet jwtClaimsSet) {
        FallbackableClaim fallbackableClaim = new FallbackableClaim(this.claimName, this.fallbackClaimNames, jwtClaimsSet);
        List<String> claimValues = this.getStringClaimValues(fallbackableClaim);
        if (claimValues == null) {
            throw new IllegalArgumentException("missing required string claim [" + fallbackableClaim + "]");
        }
        for (String claimValue : claimValues) {
            if (!this.allowedClaimValuesPredicate.test(claimValue)) continue;
            return;
        }
        throw new IllegalArgumentException("string claim [" + fallbackableClaim + "] has value [" + Strings.collectionToCommaDelimitedString(claimValues) + "] which does not match allowed claim values " + this.allowedClaimValuesPredicate);
    }

    private List<String> getStringClaimValues(FallbackableClaim fallbackableClaim) {
        if (this.singleValuedClaim) {
            String claimValue = fallbackableClaim.getStringClaimValue();
            return claimValue != null ? List.of(claimValue) : null;
        }
        return fallbackableClaim.getStringListClaimValue();
    }

    private static Predicate<String> predicateFromPatterns(String claimName, Collection<String> patterns) {
        try {
            return Automatons.predicate(patterns);
        }
        catch (Exception e) {
            throw new SettingsException("Invalid patterns for allowed claim values for [" + claimName + "].", (Throwable)e);
        }
    }
}

