/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.security.rest;

import java.io.IOException;
import java.util.List;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.message.Message;
import org.apache.logging.log4j.message.ParameterizedMessage;
import org.elasticsearch.ExceptionsHelper;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.client.node.NodeClient;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.util.Maps;
import org.elasticsearch.common.util.concurrent.ThreadContext;
import org.elasticsearch.http.HttpChannel;
import org.elasticsearch.rest.BytesRestResponse;
import org.elasticsearch.rest.RestChannel;
import org.elasticsearch.rest.RestHandler;
import org.elasticsearch.rest.RestRequest;
import org.elasticsearch.rest.RestRequestFilter;
import org.elasticsearch.rest.RestResponse;
import org.elasticsearch.rest.RestStatus;
import org.elasticsearch.xcontent.MediaType;
import org.elasticsearch.xcontent.MediaTypeRegistry;
import org.elasticsearch.xpack.core.XPackSettings;
import org.elasticsearch.xpack.core.security.authc.Authentication;
import org.elasticsearch.xpack.core.security.authc.support.SecondaryAuthentication;
import org.elasticsearch.xpack.security.authc.AuthenticationService;
import org.elasticsearch.xpack.security.authc.support.SecondaryAuthenticator;
import org.elasticsearch.xpack.security.rest.RemoteHostHeader;
import org.elasticsearch.xpack.security.transport.SSLEngineUtils;

public class SecurityRestFilter
implements RestHandler {
    private static final Logger logger = LogManager.getLogger(SecurityRestFilter.class);
    private final RestHandler restHandler;
    private final AuthenticationService authenticationService;
    private final SecondaryAuthenticator secondaryAuthenticator;
    private final Settings settings;
    private final ThreadContext threadContext;
    private final boolean extractClientCertificate;

    public SecurityRestFilter(Settings settings, ThreadContext threadContext, AuthenticationService authenticationService, SecondaryAuthenticator secondaryAuthenticator, RestHandler restHandler, boolean extractClientCertificate) {
        this.settings = settings;
        this.threadContext = threadContext;
        this.authenticationService = authenticationService;
        this.secondaryAuthenticator = secondaryAuthenticator;
        this.restHandler = restHandler;
        this.extractClientCertificate = extractClientCertificate;
    }

    public boolean allowSystemIndexAccessByDefault() {
        return this.restHandler.allowSystemIndexAccessByDefault();
    }

    public void handleRequest(RestRequest request, RestChannel channel, NodeClient client) throws Exception {
        if (request.method() == RestRequest.Method.OPTIONS) {
            this.restHandler.handleRequest(request, channel, client);
            return;
        }
        if (((Boolean)XPackSettings.SECURITY_ENABLED.get(this.settings)).booleanValue()) {
            if (this.extractClientCertificate) {
                HttpChannel httpChannel = request.getHttpChannel();
                SSLEngineUtils.extractClientCertificates(logger, this.threadContext, httpChannel);
            }
            String requestUri = request.uri();
            this.authenticationService.authenticate(this.maybeWrapRestRequest(request), (ActionListener<Authentication>)ActionListener.wrap(authentication -> {
                if (authentication == null) {
                    logger.trace("No authentication available for REST request [{}]", (Object)requestUri);
                } else {
                    logger.trace("Authenticated REST request [{}] as {}", (Object)requestUri, authentication);
                }
                this.secondaryAuthenticator.authenticateAndAttachToContext(request, (ActionListener<SecondaryAuthentication>)ActionListener.wrap(secondaryAuthentication -> {
                    if (secondaryAuthentication != null) {
                        logger.trace("Found secondary authentication {} in REST request [{}]", secondaryAuthentication, (Object)requestUri);
                    }
                    RemoteHostHeader.process(request, this.threadContext);
                    try {
                        this.restHandler.handleRequest(request, channel, client);
                    }
                    catch (Exception e) {
                        this.handleException(ActionType.RequestHandling, request, channel, e);
                    }
                }, e -> this.handleException(ActionType.SecondaryAuthentication, request, channel, (Exception)e)));
            }, e -> this.handleException(ActionType.Authentication, request, channel, (Exception)e)));
        } else {
            this.restHandler.handleRequest(request, channel, client);
        }
    }

    protected void handleException(final ActionType actionType, RestRequest request, RestChannel channel, Exception e) {
        logger.debug((Message)new ParameterizedMessage("{} failed for REST request [{}]", (Object)actionType, (Object)request.uri()), (Throwable)e);
        final RestStatus restStatus = ExceptionsHelper.status((Throwable)e);
        try {
            channel.sendResponse((RestResponse)new BytesRestResponse(channel, restStatus, e){

                protected boolean skipStackTrace() {
                    return restStatus == RestStatus.UNAUTHORIZED;
                }

                public Map<String, List<String>> filterHeaders(Map<String, List<String>> headers) {
                    if (actionType != ActionType.RequestHandling || restStatus == RestStatus.UNAUTHORIZED || restStatus == RestStatus.FORBIDDEN) {
                        if (headers.containsKey("Warning")) {
                            headers = Maps.copyMapWithRemovedEntry(headers, (Object)"Warning");
                        }
                        if (headers.containsKey("X-elastic-product")) {
                            headers = Maps.copyMapWithRemovedEntry((Map)headers, (Object)"X-elastic-product");
                        }
                    }
                    return headers;
                }
            });
        }
        catch (Exception inner) {
            inner.addSuppressed(e);
            logger.error(() -> new ParameterizedMessage("failed to send failure response for uri [{}]", (Object)request.uri()), (Throwable)inner);
        }
    }

    public boolean canTripCircuitBreaker() {
        return this.restHandler.canTripCircuitBreaker();
    }

    public boolean supportsContentStream() {
        return this.restHandler.supportsContentStream();
    }

    public boolean allowsUnsafeBuffers() {
        return this.restHandler.allowsUnsafeBuffers();
    }

    public List<RestHandler.Route> routes() {
        return this.restHandler.routes();
    }

    private RestRequest maybeWrapRestRequest(RestRequest restRequest) throws IOException {
        if (this.restHandler instanceof RestRequestFilter) {
            return ((RestRequestFilter)this.restHandler).getFilteredRequest(restRequest);
        }
        return restRequest;
    }

    public MediaTypeRegistry<? extends MediaType> validAcceptMediaTypes() {
        return this.restHandler.validAcceptMediaTypes();
    }

    public static enum ActionType {
        Authentication("Authentication"),
        SecondaryAuthentication("Secondary authentication"),
        RequestHandling("Request handling");

        private final String name;

        private ActionType(String name) {
            this.name = name;
        }

        public String toString() {
            return this.name;
        }
    }
}

