/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.security.authc;

import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.message.Message;
import org.apache.logging.log4j.message.ParameterizedMessage;
import org.elasticsearch.ElasticsearchSecurityException;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.common.settings.SecureString;
import org.elasticsearch.xpack.core.security.authc.Authentication;
import org.elasticsearch.xpack.core.security.authc.AuthenticationResult;
import org.elasticsearch.xpack.core.security.authc.AuthenticationToken;
import org.elasticsearch.xpack.security.authc.Authenticator;
import org.elasticsearch.xpack.security.authc.BearerToken;
import org.elasticsearch.xpack.security.authc.TokenService;
import org.elasticsearch.xpack.security.authc.UserToken;

class OAuth2TokenAuthenticator
implements Authenticator {
    private static final Logger logger = LogManager.getLogger(OAuth2TokenAuthenticator.class);
    private final TokenService tokenService;

    OAuth2TokenAuthenticator(TokenService tokenService) {
        this.tokenService = tokenService;
    }

    @Override
    public String name() {
        return "oauth2 token";
    }

    @Override
    public AuthenticationToken extractCredentials(Authenticator.Context context) {
        SecureString bearerString = context.getBearerString();
        return bearerString == null ? null : new BearerToken(bearerString);
    }

    @Override
    public void authenticate(Authenticator.Context context, ActionListener<AuthenticationResult<Authentication>> listener) {
        AuthenticationToken authenticationToken = context.getMostRecentAuthenticationToken();
        if (!(authenticationToken instanceof BearerToken)) {
            listener.onResponse((Object)AuthenticationResult.notHandled());
            return;
        }
        BearerToken bearerToken = (BearerToken)authenticationToken;
        this.tokenService.tryAuthenticateToken(bearerToken.credentials(), (ActionListener<UserToken>)ActionListener.wrap(userToken -> {
            if (userToken != null) {
                listener.onResponse((Object)AuthenticationResult.success((Object)userToken.getAuthentication()));
            } else {
                listener.onResponse((Object)AuthenticationResult.unsuccessful((String)"invalid token", null));
            }
        }, e -> {
            logger.debug((Message)new ParameterizedMessage("Failed to validate token authentication for request [{}]", (Object)context.getRequest()), (Throwable)e);
            if (e instanceof ElasticsearchSecurityException && !this.tokenService.isExpiredTokenException((ElasticsearchSecurityException)((Object)((Object)e)))) {
                context.getRequest().tamperedRequest();
            }
            listener.onFailure(e);
        }));
    }
}

