/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.security.transport.filter;

import io.netty.handler.ipfilter.IpFilterRuleType;
import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.lucene.util.SetOnce;
import org.elasticsearch.common.collect.MapBuilder;
import org.elasticsearch.common.settings.ClusterSettings;
import org.elasticsearch.common.settings.Setting;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.transport.BoundTransportAddress;
import org.elasticsearch.common.transport.TransportAddress;
import org.elasticsearch.license.XPackLicenseState;
import org.elasticsearch.xpack.core.security.SecurityField;
import org.elasticsearch.xpack.security.audit.AuditTrail;
import org.elasticsearch.xpack.security.audit.AuditTrailService;
import org.elasticsearch.xpack.security.transport.filter.SecurityIpFilterRule;

public class IPFilter {
    public static final String HTTP_PROFILE_NAME = ".http";
    public static final Setting<Boolean> ALLOW_BOUND_ADDRESSES_SETTING = Setting.boolSetting((String)SecurityField.setting((String)"filter.always_allow_bound_address"), (boolean)true, (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope});
    public static final Setting<Boolean> IP_FILTER_ENABLED_HTTP_SETTING = Setting.boolSetting((String)SecurityField.setting((String)"http.filter.enabled"), (boolean)true, (Setting.Property[])new Setting.Property[]{Setting.Property.OperatorDynamic, Setting.Property.NodeScope});
    public static final Setting<Boolean> IP_FILTER_ENABLED_SETTING = Setting.boolSetting((String)SecurityField.setting((String)"transport.filter.enabled"), (boolean)true, (Setting.Property[])new Setting.Property[]{Setting.Property.OperatorDynamic, Setting.Property.NodeScope});
    private static final IPFilterValidator ALLOW_VALIDATOR = new IPFilterValidator(true);
    private static final IPFilterValidator DENY_VALIDATOR = new IPFilterValidator(false);
    public static final Setting<List<String>> TRANSPORT_FILTER_ALLOW_SETTING = Setting.listSetting((String)SecurityField.setting((String)"transport.filter.allow"), Collections.emptyList(), Function.identity(), (Setting.Validator)ALLOW_VALIDATOR, (Setting.Property[])new Setting.Property[]{Setting.Property.OperatorDynamic, Setting.Property.NodeScope});
    public static final Setting<List<String>> TRANSPORT_FILTER_DENY_SETTING = Setting.listSetting((String)SecurityField.setting((String)"transport.filter.deny"), Collections.emptyList(), Function.identity(), (Setting.Validator)DENY_VALIDATOR, (Setting.Property[])new Setting.Property[]{Setting.Property.OperatorDynamic, Setting.Property.NodeScope});
    public static final Setting.AffixSetting<List<String>> PROFILE_FILTER_DENY_SETTING = Setting.affixKeySetting((String)"transport.profiles.", (String)"xpack.security.filter.deny", key -> Setting.listSetting((String)key, Collections.emptyList(), Function.identity(), (Setting.Validator)DENY_VALIDATOR, (Setting.Property[])new Setting.Property[]{Setting.Property.OperatorDynamic, Setting.Property.NodeScope}), (Setting.AffixSettingDependency[])new Setting.AffixSettingDependency[0]);
    public static final Setting.AffixSetting<List<String>> PROFILE_FILTER_ALLOW_SETTING = Setting.affixKeySetting((String)"transport.profiles.", (String)"xpack.security.filter.allow", key -> Setting.listSetting((String)key, Collections.emptyList(), Function.identity(), (Setting.Validator)ALLOW_VALIDATOR, (Setting.Property[])new Setting.Property[]{Setting.Property.OperatorDynamic, Setting.Property.NodeScope}), (Setting.AffixSettingDependency[])new Setting.AffixSettingDependency[0]);
    private static final Setting<List<String>> HTTP_FILTER_ALLOW_FALLBACK = Setting.listSetting((String)"transport.profiles.default.xpack.security.filter.allow", TRANSPORT_FILTER_ALLOW_SETTING, Function.identity(), arg_0 -> TRANSPORT_FILTER_ALLOW_SETTING.get(arg_0), (Setting.Validator)ALLOW_VALIDATOR, (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope});
    public static final Setting<List<String>> HTTP_FILTER_ALLOW_SETTING = Setting.listSetting((String)SecurityField.setting((String)"http.filter.allow"), HTTP_FILTER_ALLOW_FALLBACK, Function.identity(), arg_0 -> HTTP_FILTER_ALLOW_FALLBACK.get(arg_0), (Setting.Validator)ALLOW_VALIDATOR, (Setting.Property[])new Setting.Property[]{Setting.Property.OperatorDynamic, Setting.Property.NodeScope});
    private static final Setting<List<String>> HTTP_FILTER_DENY_FALLBACK = Setting.listSetting((String)"transport.profiles.default.xpack.security.filter.deny", TRANSPORT_FILTER_DENY_SETTING, Function.identity(), arg_0 -> TRANSPORT_FILTER_DENY_SETTING.get(arg_0), (Setting.Validator)DENY_VALIDATOR, (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope});
    public static final Setting<List<String>> HTTP_FILTER_DENY_SETTING = Setting.listSetting((String)SecurityField.setting((String)"http.filter.deny"), HTTP_FILTER_DENY_FALLBACK, Function.identity(), arg_0 -> HTTP_FILTER_DENY_FALLBACK.get(arg_0), (Setting.Validator)DENY_VALIDATOR, (Setting.Property[])new Setting.Property[]{Setting.Property.OperatorDynamic, Setting.Property.NodeScope});
    public static final Map<String, Object> DISABLED_USAGE_STATS = new MapBuilder().put((Object)"http", (Object)false).put((Object)"transport", (Object)false).immutableMap();
    public static final SecurityIpFilterRule DEFAULT_PROFILE_ACCEPT_ALL = new SecurityIpFilterRule(true, "default:accept_all"){

        @Override
        public boolean matches(InetSocketAddress remoteAddress) {
            return true;
        }

        @Override
        public IpFilterRuleType ruleType() {
            return IpFilterRuleType.ACCEPT;
        }
    };
    private static final Logger logger = LogManager.getLogger(IPFilter.class);
    private final AuditTrailService auditTrailService;
    private final XPackLicenseState licenseState;
    private final boolean alwaysAllowBoundAddresses;
    private volatile Map<String, SecurityIpFilterRule[]> rules = Collections.emptyMap();
    private volatile boolean isIpFilterEnabled;
    private volatile boolean isHttpFilterEnabled;
    private final Set<String> profiles;
    private volatile List<String> transportAllowFilter;
    private volatile List<String> transportDenyFilter;
    private volatile List<String> httpAllowFilter;
    private volatile List<String> httpDenyFilter;
    private final SetOnce<BoundTransportAddress> boundTransportAddress = new SetOnce();
    private final SetOnce<BoundTransportAddress> boundHttpTransportAddress = new SetOnce();
    private final SetOnce<Map<String, BoundTransportAddress>> profileBoundAddress = new SetOnce();
    private final Map<String, List<String>> profileAllowRules = Collections.synchronizedMap(new HashMap());
    private final Map<String, List<String>> profileDenyRules = Collections.synchronizedMap(new HashMap());

    public IPFilter(Settings settings, AuditTrailService auditTrailService, ClusterSettings clusterSettings, XPackLicenseState licenseState) {
        this.auditTrailService = auditTrailService;
        this.licenseState = licenseState;
        this.alwaysAllowBoundAddresses = (Boolean)ALLOW_BOUND_ADDRESSES_SETTING.get(settings);
        this.httpDenyFilter = (List)HTTP_FILTER_DENY_SETTING.get(settings);
        this.httpAllowFilter = (List)HTTP_FILTER_ALLOW_SETTING.get(settings);
        this.transportAllowFilter = (List)TRANSPORT_FILTER_ALLOW_SETTING.get(settings);
        this.transportDenyFilter = (List)TRANSPORT_FILTER_DENY_SETTING.get(settings);
        this.isHttpFilterEnabled = (Boolean)IP_FILTER_ENABLED_HTTP_SETTING.get(settings);
        this.isIpFilterEnabled = (Boolean)IP_FILTER_ENABLED_SETTING.get(settings);
        this.profiles = settings.getGroups("transport.profiles.", true).keySet().stream().filter(k -> !"default".equals(k)).collect(Collectors.toSet());
        for (String profile : this.profiles) {
            Setting allowSetting = PROFILE_FILTER_ALLOW_SETTING.getConcreteSettingForNamespace(profile);
            this.profileAllowRules.put(profile, (List)allowSetting.get(settings));
            Setting denySetting = PROFILE_FILTER_DENY_SETTING.getConcreteSettingForNamespace(profile);
            this.profileDenyRules.put(profile, (List)denySetting.get(settings));
        }
        clusterSettings.addSettingsUpdateConsumer(IP_FILTER_ENABLED_HTTP_SETTING, this::setHttpFiltering);
        clusterSettings.addSettingsUpdateConsumer(IP_FILTER_ENABLED_SETTING, this::setTransportFiltering);
        clusterSettings.addSettingsUpdateConsumer(TRANSPORT_FILTER_ALLOW_SETTING, this::setTransportAllowFilter);
        clusterSettings.addSettingsUpdateConsumer(TRANSPORT_FILTER_DENY_SETTING, this::setTransportDenyFilter);
        clusterSettings.addSettingsUpdateConsumer(HTTP_FILTER_ALLOW_SETTING, this::setHttpAllowFilter);
        clusterSettings.addSettingsUpdateConsumer(HTTP_FILTER_DENY_SETTING, this::setHttpDenyFilter);
        clusterSettings.addAffixUpdateConsumer(PROFILE_FILTER_ALLOW_SETTING, this::setProfileAllowRules, (a, b) -> {});
        clusterSettings.addAffixUpdateConsumer(PROFILE_FILTER_DENY_SETTING, this::setProfileDenyRules, (a, b) -> {});
        this.updateRules();
    }

    public Map<String, Object> usageStats() {
        HashMap<String, Object> map = new HashMap<String, Object>(2);
        boolean httpFilterEnabled = this.isHttpFilterEnabled && (!this.httpAllowFilter.isEmpty() || !this.httpDenyFilter.isEmpty());
        boolean transportFilterEnabled = this.isIpFilterEnabled && (!this.transportAllowFilter.isEmpty() || !this.transportDenyFilter.isEmpty());
        map.put("http", httpFilterEnabled);
        map.put("transport", transportFilterEnabled);
        return map;
    }

    private void setProfileAllowRules(String profile, List<String> rules) {
        this.profileAllowRules.put(profile, rules);
        this.updateRules();
    }

    private void setProfileDenyRules(String profile, List<String> rules) {
        this.profileDenyRules.put(profile, rules);
        this.updateRules();
    }

    private void setHttpDenyFilter(List<String> filter) {
        this.httpDenyFilter = filter;
        this.updateRules();
    }

    private void setHttpAllowFilter(List<String> filter) {
        this.httpAllowFilter = filter;
        this.updateRules();
    }

    private void setTransportDenyFilter(List<String> filter) {
        this.transportDenyFilter = filter;
        this.updateRules();
    }

    private void setTransportAllowFilter(List<String> filter) {
        this.transportAllowFilter = filter;
        this.updateRules();
    }

    private void setTransportFiltering(boolean enabled) {
        this.isIpFilterEnabled = enabled;
        this.updateRules();
    }

    private void setHttpFiltering(boolean enabled) {
        this.isHttpFilterEnabled = enabled;
        this.updateRules();
    }

    public boolean accept(String profile, InetSocketAddress peerAddress) {
        if (!this.licenseState.isSecurityEnabled() || !this.licenseState.checkFeature(XPackLicenseState.Feature.SECURITY_IP_FILTERING)) {
            return true;
        }
        if (!this.rules.containsKey(profile)) {
            return true;
        }
        AuditTrail auditTrail = this.auditTrailService.get();
        for (SecurityIpFilterRule rule : this.rules.get(profile)) {
            boolean isAllowed;
            if (!rule.matches(peerAddress)) continue;
            boolean bl = isAllowed = rule.ruleType() == IpFilterRuleType.ACCEPT;
            if (isAllowed) {
                auditTrail.connectionGranted(peerAddress.getAddress(), profile, rule);
            } else {
                auditTrail.connectionDenied(peerAddress.getAddress(), profile, rule);
            }
            return isAllowed;
        }
        auditTrail.connectionGranted(peerAddress.getAddress(), profile, DEFAULT_PROFILE_ACCEPT_ALL);
        return true;
    }

    private synchronized void updateRules() {
        this.rules = this.parseSettings();
    }

    private Map<String, SecurityIpFilterRule[]> parseSettings() {
        if (this.isIpFilterEnabled || this.isHttpFilterEnabled) {
            TransportAddress[] localAddresses;
            HashMap<String, SecurityIpFilterRule[]> profileRules = new HashMap<String, SecurityIpFilterRule[]>();
            if (this.isHttpFilterEnabled && this.boundHttpTransportAddress.get() != null) {
                localAddresses = ((BoundTransportAddress)this.boundHttpTransportAddress.get()).boundAddresses();
                profileRules.put(HTTP_PROFILE_NAME, this.createRules(this.httpAllowFilter, this.httpDenyFilter, localAddresses));
            }
            if (this.isIpFilterEnabled && this.boundTransportAddress.get() != null) {
                localAddresses = ((BoundTransportAddress)this.boundTransportAddress.get()).boundAddresses();
                profileRules.put("default", this.createRules(this.transportAllowFilter, this.transportDenyFilter, localAddresses));
                for (String profile : this.profiles) {
                    BoundTransportAddress profileBoundTransportAddress = (BoundTransportAddress)((Map)this.profileBoundAddress.get()).get(profile);
                    if (profileBoundTransportAddress == null) {
                        logger.warn("skipping ip filter rules for profile [{}] since the profile is not bound to any addresses", (Object)profile);
                        continue;
                    }
                    List<String> allowRules = this.profileAllowRules.getOrDefault(profile, Collections.emptyList());
                    List<String> denyRules = this.profileDenyRules.getOrDefault(profile, Collections.emptyList());
                    profileRules.put(profile, this.createRules(allowRules, denyRules, profileBoundTransportAddress.boundAddresses()));
                }
            }
            logger.debug("loaded ip filtering profiles: {}", profileRules.keySet());
            return Collections.unmodifiableMap(profileRules);
        }
        return Collections.emptyMap();
    }

    private SecurityIpFilterRule[] createRules(List<String> allow, List<String> deny, TransportAddress[] boundAddresses) {
        ArrayList<SecurityIpFilterRule> rules = new ArrayList<SecurityIpFilterRule>();
        if (this.alwaysAllowBoundAddresses) {
            assert (boundAddresses != null && boundAddresses.length > 0);
            rules.add(new SecurityIpFilterRule(true, boundAddresses));
        }
        for (String value : allow) {
            rules.add(new SecurityIpFilterRule(true, value));
        }
        for (String value : deny) {
            rules.add(new SecurityIpFilterRule(false, value));
        }
        return rules.toArray(new SecurityIpFilterRule[rules.size()]);
    }

    public void setBoundTransportAddress(BoundTransportAddress boundTransportAddress, Map<String, BoundTransportAddress> profileBoundAddress) {
        this.boundTransportAddress.set((Object)boundTransportAddress);
        this.profileBoundAddress.set(profileBoundAddress);
        this.updateRules();
    }

    public void setBoundHttpTransportAddress(BoundTransportAddress boundHttpTransportAddress) {
        this.boundHttpTransportAddress.set((Object)boundHttpTransportAddress);
        this.updateRules();
    }

    public static void addSettings(List<Setting<?>> settings) {
        settings.add(ALLOW_BOUND_ADDRESSES_SETTING);
        settings.add(IP_FILTER_ENABLED_SETTING);
        settings.add(IP_FILTER_ENABLED_HTTP_SETTING);
        settings.add(HTTP_FILTER_ALLOW_SETTING);
        settings.add(HTTP_FILTER_DENY_SETTING);
        settings.add(TRANSPORT_FILTER_ALLOW_SETTING);
        settings.add(TRANSPORT_FILTER_DENY_SETTING);
        settings.add((Setting<?>)PROFILE_FILTER_ALLOW_SETTING);
        settings.add((Setting<?>)PROFILE_FILTER_DENY_SETTING);
    }

    private static class IPFilterValidator
    implements Setting.Validator<List<String>> {
        private final boolean isAllowRule;

        IPFilterValidator(boolean isAllowRule) {
            this.isAllowRule = isAllowRule;
        }

        public void validate(List<String> filterSpecs) {
            for (String filterSpec : filterSpecs) {
                try {
                    new SecurityIpFilterRule(this.isAllowRule, filterSpec);
                }
                catch (Exception e) {
                    throw new IllegalArgumentException("invalid IP filter [" + filterSpec + "]", e);
                }
            }
        }
    }
}

