/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.security.rest.action.privilege;

import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.client.ElasticsearchClient;
import org.elasticsearch.client.node.NodeClient;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.util.set.Sets;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.core.RestApiVersion;
import org.elasticsearch.license.XPackLicenseState;
import org.elasticsearch.rest.BaseRestHandler;
import org.elasticsearch.rest.BytesRestResponse;
import org.elasticsearch.rest.RestHandler;
import org.elasticsearch.rest.RestRequest;
import org.elasticsearch.rest.RestResponse;
import org.elasticsearch.rest.RestStatus;
import org.elasticsearch.rest.action.RestBuilderListener;
import org.elasticsearch.xpack.core.security.action.privilege.GetPrivilegesResponse;
import org.elasticsearch.xpack.core.security.authz.privilege.ApplicationPrivilegeDescriptor;
import org.elasticsearch.xpack.core.security.client.SecurityClient;
import org.elasticsearch.xpack.security.rest.action.SecurityBaseRestHandler;

public class RestGetPrivilegesAction
extends SecurityBaseRestHandler {
    public RestGetPrivilegesAction(Settings settings, XPackLicenseState licenseState) {
        super(settings, licenseState);
    }

    public List<RestHandler.Route> routes() {
        return org.elasticsearch.core.List.of((Object[])new RestHandler.Route[]{RestHandler.Route.builder((RestRequest.Method)RestRequest.Method.GET, (String)"/_security/privilege/").replaces(RestRequest.Method.GET, "/_xpack/security/privilege/", RestApiVersion.V_7).build(), RestHandler.Route.builder((RestRequest.Method)RestRequest.Method.GET, (String)"/_security/privilege/{application}").replaces(RestRequest.Method.GET, "/_xpack/security/privilege/{application}", RestApiVersion.V_7).build(), RestHandler.Route.builder((RestRequest.Method)RestRequest.Method.GET, (String)"/_security/privilege/{application}/{privilege}").replaces(RestRequest.Method.GET, "/_xpack/security/privilege/{application}/{privilege}", RestApiVersion.V_7).build()});
    }

    public String getName() {
        return "security_get_privileges_action";
    }

    @Override
    public BaseRestHandler.RestChannelConsumer innerPrepareRequest(RestRequest request, NodeClient client) throws IOException {
        String application = request.param("application");
        final String[] privileges = request.paramAsStringArray("privilege", Strings.EMPTY_ARRAY);
        return channel -> new SecurityClient((ElasticsearchClient)client).prepareGetPrivileges(application, privileges).execute((ActionListener)new RestBuilderListener<GetPrivilegesResponse>(channel){

            public RestResponse buildResponse(GetPrivilegesResponse response, XContentBuilder builder) throws Exception {
                Map<String, Set<ApplicationPrivilegeDescriptor>> privsByApp = RestGetPrivilegesAction.groupByApplicationName(response.privileges());
                builder.startObject();
                for (String app : privsByApp.keySet()) {
                    builder.startObject(app);
                    for (ApplicationPrivilegeDescriptor privilege : privsByApp.get(app)) {
                        builder.field(privilege.getName(), (ToXContent)privilege);
                    }
                    builder.endObject();
                }
                builder.endObject();
                if (privileges.length != 0 && response.privileges().length == 0) {
                    return new BytesRestResponse(RestStatus.NOT_FOUND, builder);
                }
                return new BytesRestResponse(RestStatus.OK, builder);
            }
        });
    }

    static Map<String, Set<ApplicationPrivilegeDescriptor>> groupByApplicationName(ApplicationPrivilegeDescriptor[] privileges) {
        return Arrays.stream(privileges).collect(Collectors.toMap(ApplicationPrivilegeDescriptor::getApplication, Collections::singleton, Sets::union));
    }
}

