/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.security.authc.support;

import java.util.Arrays;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Consumer;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.message.Message;
import org.apache.logging.log4j.message.ParameterizedMessage;
import org.apache.lucene.util.SetOnce;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.discovery.DiscoveryModule;
import org.elasticsearch.transport.Transport;
import org.elasticsearch.xpack.core.XPackSettings;

public class HttpTlsRuntimeCheck {
    private static final Logger logger = LogManager.getLogger(HttpTlsRuntimeCheck.class);
    private final AtomicBoolean initialized = new AtomicBoolean(false);
    private final Boolean httpTlsEnabled;
    private final SetOnce<Transport> transportReference;
    private final Boolean securityEnabled;
    private final boolean singleNodeDiscovery;
    private boolean enforce;

    public HttpTlsRuntimeCheck(Settings settings, SetOnce<Transport> transportReference) {
        this.transportReference = transportReference;
        this.securityEnabled = (Boolean)XPackSettings.SECURITY_ENABLED.get(settings);
        this.httpTlsEnabled = (Boolean)XPackSettings.HTTP_SSL_ENABLED.get(settings);
        this.singleNodeDiscovery = "single-node".equals(DiscoveryModule.DISCOVERY_TYPE_SETTING.get(settings));
    }

    public void checkTlsThenExecute(Consumer<Exception> exceptionConsumer, String featureName, Runnable andThen) {
        if (this.securityEnabled.booleanValue() && !this.httpTlsEnabled.booleanValue()) {
            if (!this.initialized.get()) {
                Transport transport = (Transport)this.transportReference.get();
                if (transport == null) {
                    exceptionConsumer.accept((Exception)((Object)new ElasticsearchException("transport cannot be null", new Object[0])));
                    return;
                }
                boolean boundToLocal = Arrays.stream(transport.boundAddress().boundAddresses()).allMatch(b -> b.address().getAddress().isLoopbackAddress()) && transport.boundAddress().publishAddress().address().getAddress().isLoopbackAddress();
                this.enforce = false == boundToLocal && false == this.singleNodeDiscovery;
                this.initialized.set(true);
            }
            if (this.enforce) {
                ParameterizedMessage message = new ParameterizedMessage("[{}] requires TLS for the HTTP interface", (Object)featureName);
                logger.debug((Message)message);
                exceptionConsumer.accept((Exception)((Object)new ElasticsearchException(message.getFormattedMessage(), new Object[0])));
                return;
            }
        }
        andThen.run();
    }
}

