/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.security.authc.saml;

import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.security.PrivateKey;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;
import joptsimple.OptionParser;
import joptsimple.OptionSet;
import joptsimple.OptionSpec;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.cli.KeyStoreAwareCommand;
import org.elasticsearch.cli.SuppressForbidden;
import org.elasticsearch.cli.Terminal;
import org.elasticsearch.cli.UserException;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.logging.Loggers;
import org.elasticsearch.common.settings.KeyStoreWrapper;
import org.elasticsearch.common.settings.SecureSettings;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.util.LocaleUtils;
import org.elasticsearch.common.util.concurrent.ThreadContext;
import org.elasticsearch.core.CheckedFunction;
import org.elasticsearch.core.PathUtils;
import org.elasticsearch.env.Environment;
import org.elasticsearch.xpack.core.security.authc.RealmConfig;
import org.elasticsearch.xpack.core.security.authc.RealmSettings;
import org.elasticsearch.xpack.core.security.authc.saml.SamlRealmSettings;
import org.elasticsearch.xpack.core.ssl.CertParsingUtils;
import org.elasticsearch.xpack.core.ssl.PemUtils;
import org.elasticsearch.xpack.security.authc.saml.SamlRealm;
import org.elasticsearch.xpack.security.authc.saml.SamlSpMetadataBuilder;
import org.elasticsearch.xpack.security.authc.saml.SamlUtils;
import org.elasticsearch.xpack.security.authc.saml.SpConfiguration;
import org.opensaml.core.xml.XMLObject;
import org.opensaml.core.xml.config.XMLObjectProviderRegistrySupport;
import org.opensaml.core.xml.io.MarshallingException;
import org.opensaml.saml.saml2.metadata.EntityDescriptor;
import org.opensaml.saml.saml2.metadata.impl.EntityDescriptorMarshaller;
import org.opensaml.security.credential.Credential;
import org.opensaml.security.x509.BasicX509Credential;
import org.opensaml.xmlsec.signature.Signature;
import org.opensaml.xmlsec.signature.support.SignatureException;
import org.opensaml.xmlsec.signature.support.Signer;
import org.w3c.dom.Element;
import org.xml.sax.SAXException;

public class SamlMetadataCommand
extends KeyStoreAwareCommand {
    static final String METADATA_SCHEMA = "saml-schema-metadata-2.0.xsd";
    private final OptionSpec<String> outputPathSpec;
    private final OptionSpec<Void> batchSpec;
    private final OptionSpec<String> realmSpec;
    private final OptionSpec<String> localeSpec;
    private final OptionSpec<String> serviceNameSpec;
    private final OptionSpec<String> attributeSpec;
    private final OptionSpec<String> orgNameSpec;
    private final OptionSpec<String> orgDisplayNameSpec;
    private final OptionSpec<String> orgUrlSpec;
    private final OptionSpec<Void> contactsSpec;
    private final OptionSpec<String> signingPkcs12PathSpec;
    private final OptionSpec<String> signingCertPathSpec;
    private final OptionSpec<String> signingKeyPathSpec;
    private final OptionSpec<String> keyPasswordSpec;
    private final CheckedFunction<Environment, KeyStoreWrapper, Exception> keyStoreFunction;
    private KeyStoreWrapper keyStoreWrapper;

    public static void main(String[] args) throws Exception {
        SamlMetadataCommand.exit((int)new SamlMetadataCommand().main(args, Terminal.DEFAULT));
    }

    public SamlMetadataCommand() {
        this((CheckedFunction<Environment, KeyStoreWrapper, Exception>)((CheckedFunction)environment -> {
            KeyStoreWrapper ksWrapper = KeyStoreWrapper.load((Path)environment.configFile());
            return ksWrapper;
        }));
    }

    public SamlMetadataCommand(CheckedFunction<Environment, KeyStoreWrapper, Exception> keyStoreFunction) {
        super("Generate Service Provider Metadata for a SAML realm");
        this.outputPathSpec = this.parser.accepts("out", "path of the xml file that should be generated").withRequiredArg();
        this.batchSpec = this.parser.accepts("batch", "Do not prompt");
        this.realmSpec = this.parser.accepts("realm", "name of the elasticsearch realm for which metadata should be generated").withRequiredArg();
        this.localeSpec = this.parser.accepts("locale", "the locale to be used for elements that require a language").withRequiredArg();
        this.serviceNameSpec = this.parser.accepts("service-name", "the name to apply to the attribute consuming service").withRequiredArg();
        this.attributeSpec = this.parser.accepts("attribute", "additional SAML attributes to request").withRequiredArg();
        this.orgNameSpec = this.parser.accepts("organisation-name", "the name of the organisation operating this service").withRequiredArg();
        this.orgDisplayNameSpec = this.parser.accepts("organisation-display-name", "the display-name of the organisation operating this service").availableIf(this.orgNameSpec, new OptionSpec[0]).withRequiredArg();
        this.orgUrlSpec = this.parser.accepts("organisation-url", "the URL of the organisation operating this service").requiredIf(this.orgNameSpec, new OptionSpec[0]).withRequiredArg();
        this.contactsSpec = this.parser.accepts("contacts", "Include contact information in metadata").availableUnless(this.batchSpec, new OptionSpec[0]);
        this.signingPkcs12PathSpec = this.parser.accepts("signing-bundle", "path to an existing key pair (in PKCS#12 format) to be used for signing ").withRequiredArg();
        this.signingCertPathSpec = this.parser.accepts("signing-cert", "path to an existing signing certificate").availableUnless(this.signingPkcs12PathSpec, new OptionSpec[0]).withRequiredArg();
        this.signingKeyPathSpec = this.parser.accepts("signing-key", "path to an existing signing private key").availableIf(this.signingCertPathSpec, new OptionSpec[0]).requiredIf(this.signingCertPathSpec, new OptionSpec[0]).withRequiredArg();
        this.keyPasswordSpec = this.parser.accepts("signing-key-password", "password for an existing signing private key or keypair").withOptionalArg();
        this.keyStoreFunction = keyStoreFunction;
    }

    public void close() throws IOException {
        super.close();
        if (this.keyStoreWrapper != null) {
            this.keyStoreWrapper.close();
        }
    }

    protected void execute(Terminal terminal, OptionSet options, Environment env) throws Exception {
        Loggers.setLevel((Logger)LogManager.getLogger((String)"org.opensaml"), (Level)Level.WARN);
        Logger logger = LogManager.getLogger(((Object)((Object)this)).getClass());
        SamlUtils.initialize(logger);
        EntityDescriptor descriptor = this.buildEntityDescriptor(terminal, options, env);
        Element element = this.possiblySignDescriptor(terminal, options, descriptor, env);
        Path xml = this.writeOutput(terminal, options, element);
        this.validateXml(terminal, xml);
    }

    EntityDescriptor buildEntityDescriptor(Terminal terminal, OptionSet options, Environment env) throws Exception {
        boolean batch = options.has(this.batchSpec);
        RealmConfig realm = this.findRealm(terminal, options, env);
        Settings realmSettings = realm.settings().getByPrefix(RealmSettings.realmSettingPrefix((RealmConfig.RealmIdentifier)realm.identifier()));
        terminal.println(Terminal.Verbosity.VERBOSE, "Using realm configuration\n=====\n" + realmSettings.toDelimitedString('\n') + "=====");
        Locale locale = this.findLocale(options);
        terminal.println(Terminal.Verbosity.VERBOSE, "Using locale: " + locale.toLanguageTag());
        SpConfiguration spConfig = SamlRealm.getSpConfiguration(realm);
        SamlSpMetadataBuilder builder = new SamlSpMetadataBuilder(locale, spConfig.getEntityId()).assertionConsumerServiceUrl(spConfig.getAscUrl()).singleLogoutServiceUrl(spConfig.getLogoutUrl()).encryptionCredentials(spConfig.getEncryptionCredentials()).signingCredential(spConfig.getSigningConfiguration().getCredential()).authnRequestsSigned(spConfig.getSigningConfiguration().shouldSign("AuthnRequest")).nameIdFormat((String)realm.getSetting(SamlRealmSettings.NAMEID_FORMAT)).serviceName(this.option(this.serviceNameSpec, options, env.settings().get("cluster.name")));
        Map<String, String> attributes = this.getAttributeNames(options, realm);
        for (String attr : attributes.keySet()) {
            String friendlyName;
            String name;
            String attributeSource;
            String settingName = attributes.get(attr);
            String string = attributeSource = settingName == null ? "command line" : '\"' + settingName + '\"';
            if (attr.contains(":")) {
                name = attr;
                if (batch) {
                    friendlyName = settingName;
                } else {
                    friendlyName = terminal.readText("What is the friendly name for " + attributeSource + " attribute \"" + attr + "\" [default: " + (settingName == null ? "none" : settingName) + "] ");
                    if (Strings.isNullOrEmpty((String)friendlyName)) {
                        friendlyName = settingName;
                    }
                }
            } else {
                if (batch) {
                    throw new UserException(78, "Option " + this.batchSpec.toString() + " is specified, but attribute " + attr + " appears to be a FriendlyName value");
                }
                friendlyName = attr;
                name = this.requireText(terminal, "What is the standard (urn) name for " + attributeSource + " attribute \"" + attr + "\" (required): ");
            }
            terminal.println(Terminal.Verbosity.VERBOSE, "Requesting attribute '" + name + "' (FriendlyName: '" + friendlyName + "')");
            builder.withAttribute(friendlyName, name);
        }
        if (options.has(this.orgNameSpec) && options.has(this.orgUrlSpec)) {
            String name = (String)this.orgNameSpec.value(options);
            builder.organization(name, this.option(this.orgDisplayNameSpec, options, name), (String)this.orgUrlSpec.value(options));
        }
        if (options.has(this.contactsSpec)) {
            terminal.println("\nPlease enter the personal details for each contact to be included in the metadata");
            do {
                String type;
                String givenName = this.requireText(terminal, "What is the given name for the contact: ");
                String surName = this.requireText(terminal, "What is the surname for the contact: ");
                String displayName = givenName + ' ' + surName;
                String email = this.requireText(terminal, "What is the email address for " + displayName + ": ");
                while (!SamlSpMetadataBuilder.ContactInfo.TYPES.containsKey(type = this.requireText(terminal, "What is the contact type for " + displayName + ": "))) {
                    terminal.errorPrintln("Type '" + type + "' is not valid. Valid values are " + Strings.collectionToCommaDelimitedString(SamlSpMetadataBuilder.ContactInfo.TYPES.keySet()));
                }
                builder.withContact(type, givenName, surName, email);
            } while (terminal.promptYesNo("Enter details for another contact", true));
        }
        return builder.build();
    }

    Element possiblySignDescriptor(Terminal terminal, OptionSet options, EntityDescriptor descriptor, Environment env) throws UserException {
        try {
            EntityDescriptorMarshaller marshaller = new EntityDescriptorMarshaller();
            if (options.has(this.signingPkcs12PathSpec) || options.has(this.signingCertPathSpec) && options.has(this.signingKeyPathSpec)) {
                Signature signature = (Signature)XMLObjectProviderRegistrySupport.getBuilderFactory().getBuilder(Signature.DEFAULT_ELEMENT_NAME).buildObject(Signature.DEFAULT_ELEMENT_NAME);
                signature.setSigningCredential(this.buildSigningCredential(terminal, options, env));
                signature.setSignatureAlgorithm("http://www.w3.org/2001/04/xmldsig-more#rsa-sha256");
                signature.setCanonicalizationAlgorithm("http://www.w3.org/2001/10/xml-exc-c14n#");
                descriptor.setSignature(signature);
                Element element = marshaller.marshall((XMLObject)descriptor);
                Signer.signObject((Signature)signature);
                return element;
            }
            return marshaller.marshall((XMLObject)descriptor);
        }
        catch (Exception e) {
            String errorMessage = e instanceof MarshallingException ? "Error serializing Metadata to file" : (e instanceof SignatureException ? "Error attempting to sign Metadata" : "Error building signing credentials from provided keyPair");
            terminal.errorPrintln(Terminal.Verbosity.SILENT, errorMessage);
            terminal.errorPrintln("The following errors were found:");
            this.printExceptions(terminal, e);
            throw new UserException(73, "Unable to create metadata document");
        }
    }

    private Path writeOutput(Terminal terminal, OptionSet options, Element element) throws Exception {
        Path outputFile = this.resolvePath(this.option(this.outputPathSpec, options, "saml-elasticsearch-metadata.xml"));
        BufferedWriter writer = Files.newBufferedWriter(outputFile, new OpenOption[0]);
        SamlUtils.print(element, writer, true);
        terminal.println("\nWrote SAML metadata to " + outputFile);
        return outputFile;
    }

    private Credential buildSigningCredential(Terminal terminal, OptionSet options, Environment env) throws Exception {
        PrivateKey signingKey;
        X509Certificate signingCertificate;
        char[] password = SamlMetadataCommand.getChars((String)this.keyPasswordSpec.value(options));
        if (options.has(this.signingPkcs12PathSpec)) {
            Path p12Path = this.resolvePath((String)this.signingPkcs12PathSpec.value(options));
            Map keys = (Map)SamlMetadataCommand.withPassword("certificate bundle (" + p12Path + ")", password, terminal, keyPassword -> CertParsingUtils.readPkcs12KeyPairs((Path)p12Path, (char[])keyPassword, a -> keyPassword));
            if (keys.size() != 1) {
                throw new IllegalArgumentException("expected a single key in file [" + p12Path.toAbsolutePath() + "] but found [" + keys.size() + "]");
            }
            Map.Entry pair = keys.entrySet().iterator().next();
            signingCertificate = (X509Certificate)pair.getKey();
            signingKey = (PrivateKey)pair.getValue();
        } else {
            Path cert = this.resolvePath((String)this.signingCertPathSpec.value(options));
            Path key = this.resolvePath((String)this.signingKeyPathSpec.value(options));
            String resolvedSigningCertPath = cert.toAbsolutePath().toString();
            Certificate[] certificates = CertParsingUtils.readCertificates(Collections.singletonList(resolvedSigningCertPath), (Environment)env);
            if (certificates.length != 1) {
                throw new IllegalArgumentException("expected a single certificate in file [" + resolvedSigningCertPath + "] but found [" + certificates.length + "]");
            }
            signingCertificate = (X509Certificate)certificates[0];
            signingKey = SamlMetadataCommand.readSigningKey(key, password, terminal);
        }
        return new BasicX509Credential(signingCertificate, signingKey);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static <T, E extends Exception> T withPassword(String description, char[] password, Terminal terminal, CheckedFunction<char[], T, E> body) throws E {
        if (password == null) {
            char[] promptedValue = terminal.readSecret("Enter password for " + description + " : ");
            try {
                Object object = body.apply((Object)promptedValue);
                return (T)object;
            }
            finally {
                Arrays.fill(promptedValue, '\u0000');
            }
        }
        return (T)body.apply((Object)password);
    }

    private static char[] getChars(String password) {
        return password == null ? null : password.toCharArray();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static PrivateKey readSigningKey(Path path, char[] password, Terminal terminal) throws Exception {
        AtomicReference<char[]> passwordReference = new AtomicReference<char[]>(password);
        try {
            PrivateKey privateKey = PemUtils.readPrivateKey((Path)path, () -> {
                if (password != null) {
                    return password;
                }
                char[] promptedValue = terminal.readSecret("Enter password for the signing key (" + path.getFileName() + ") : ");
                passwordReference.set(promptedValue);
                return promptedValue;
            });
            return privateKey;
        }
        finally {
            if (passwordReference.get() != null) {
                Arrays.fill(passwordReference.get(), '\u0000');
            }
        }
    }

    private void validateXml(Terminal terminal, Path xml) throws Exception {
        try (InputStream xmlInput = Files.newInputStream(xml, new OpenOption[0]);){
            SamlUtils.validate(xmlInput, METADATA_SCHEMA);
            terminal.println(Terminal.Verbosity.VERBOSE, "The generated metadata file conforms to the SAML metadata schema");
        }
        catch (SAXException e) {
            terminal.errorPrintln(Terminal.Verbosity.SILENT, "Error - The generated metadata file does not conform to the SAML metadata schema");
            terminal.errorPrintln("While validating " + xml.toString() + " the follow errors were found:");
            this.printExceptions(terminal, e);
            throw new UserException(70, "Generated metadata is not valid");
        }
    }

    private void printExceptions(Terminal terminal, Throwable throwable) {
        terminal.errorPrintln(" - " + throwable.getMessage());
        for (Throwable sup : throwable.getSuppressed()) {
            this.printExceptions(terminal, sup);
        }
        if (throwable.getCause() != null && throwable.getCause() != throwable) {
            this.printExceptions(terminal, throwable.getCause());
        }
    }

    @SuppressForbidden(reason="CLI tool working from current directory")
    private Path resolvePath(String name) {
        return PathUtils.get((String)name, (String[])new String[0]).normalize();
    }

    private String requireText(Terminal terminal, String prompt) {
        String value = null;
        while (Strings.isNullOrEmpty(value)) {
            value = terminal.readText(prompt);
        }
        return value;
    }

    private <T> T option(OptionSpec<T> spec, OptionSet options, T defaultValue) {
        if (options.has(spec)) {
            return (T)spec.value(options);
        }
        return defaultValue;
    }

    private Map<String, String> getAttributeNames(OptionSet options, RealmConfig realm) {
        LinkedHashMap<String, String> attributes = new LinkedHashMap<String, String>();
        for (String a : this.attributeSpec.values(options)) {
            attributes.put(a, null);
        }
        String prefix = RealmSettings.realmSettingPrefix((RealmConfig.RealmIdentifier)realm.identifier()) + "attributes.";
        Settings attributeSettings = realm.settings().getByPrefix(prefix);
        for (String key : this.sorted(attributeSettings.keySet())) {
            String attr = attributeSettings.get(key);
            attributes.put(attr, key);
        }
        return attributes;
    }

    private SortedSet<String> sorted(Set<String> strings) {
        return new TreeSet<String>(strings);
    }

    private RealmConfig findRealm(Terminal terminal, OptionSet options, Environment env) throws Exception {
        Settings settings;
        this.keyStoreWrapper = (KeyStoreWrapper)this.keyStoreFunction.apply((Object)env);
        if (this.keyStoreWrapper != null) {
            SamlMetadataCommand.decryptKeyStore((KeyStoreWrapper)this.keyStoreWrapper, (Terminal)terminal);
            Settings.Builder settingsBuilder = Settings.builder();
            settingsBuilder.put(env.settings(), true);
            if (settingsBuilder.getSecureSettings() == null) {
                settingsBuilder.setSecureSettings((SecureSettings)this.keyStoreWrapper);
            }
            settings = settingsBuilder.build();
        } else {
            settings = env.settings();
        }
        Map realms = RealmSettings.getRealmSettings((Settings)settings);
        if (options.has(this.realmSpec)) {
            String name = (String)this.realmSpec.value(options);
            RealmConfig.RealmIdentifier identifier = new RealmConfig.RealmIdentifier("saml", name);
            Settings realmSettings = (Settings)realms.get(identifier);
            if (realmSettings == null) {
                throw new UserException(78, "No such realm '" + name + "' defined in " + env.configFile());
            }
            if (this.isSamlRealm(identifier)) {
                return this.buildRealm(identifier, env, settings);
            }
            throw new UserException(78, "Realm '" + name + "' is not a SAML realm (is '" + identifier.getType() + "')");
        }
        List saml = realms.entrySet().stream().filter(entry -> this.isSamlRealm((RealmConfig.RealmIdentifier)entry.getKey())).collect(Collectors.toList());
        if (saml.isEmpty()) {
            throw new UserException(78, "There is no SAML realm configured in " + env.configFile());
        }
        if (saml.size() > 1) {
            terminal.errorPrintln("Using configuration in " + env.configFile());
            terminal.errorPrintln("Found multiple SAML realms: " + saml.stream().map(Map.Entry::getKey).map(Object::toString).collect(Collectors.joining(", ")));
            terminal.errorPrintln("Use the -" + this.optionName(this.realmSpec) + " option to specify an explicit realm");
            throw new UserException(78, "Found multiple SAML realms, please specify one with '-" + this.optionName(this.realmSpec) + "'");
        }
        Map.Entry entry2 = (Map.Entry)saml.get(0);
        terminal.println("Building metadata for SAML realm " + entry2.getKey());
        return this.buildRealm((RealmConfig.RealmIdentifier)entry2.getKey(), env, settings);
    }

    private String optionName(OptionSpec<?> spec) {
        return (String)spec.options().get(0);
    }

    private RealmConfig buildRealm(RealmConfig.RealmIdentifier identifier, Environment env, Settings globalSettings) {
        return new RealmConfig(identifier, globalSettings, env, new ThreadContext(globalSettings));
    }

    private boolean isSamlRealm(RealmConfig.RealmIdentifier realmIdentifier) {
        return "saml".equals(realmIdentifier.getType());
    }

    private Locale findLocale(OptionSet options) {
        if (options.has(this.localeSpec)) {
            return LocaleUtils.parse((String)((String)this.localeSpec.value(options)));
        }
        return Locale.getDefault();
    }

    OptionParser getParser() {
        return this.parser;
    }
}

