/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.security.rest.action.user;

import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.client.ElasticsearchClient;
import org.elasticsearch.client.node.NodeClient;
import org.elasticsearch.common.RestApiVersion;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.util.set.Sets;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.license.XPackLicenseState;
import org.elasticsearch.rest.BaseRestHandler;
import org.elasticsearch.rest.BytesRestResponse;
import org.elasticsearch.rest.RestHandler;
import org.elasticsearch.rest.RestRequest;
import org.elasticsearch.rest.RestRequestFilter;
import org.elasticsearch.rest.RestResponse;
import org.elasticsearch.rest.RestStatus;
import org.elasticsearch.rest.action.RestBuilderListener;
import org.elasticsearch.xpack.core.XPackSettings;
import org.elasticsearch.xpack.core.security.action.user.PutUserRequestBuilder;
import org.elasticsearch.xpack.core.security.action.user.PutUserResponse;
import org.elasticsearch.xpack.core.security.authc.support.Hasher;
import org.elasticsearch.xpack.core.security.client.SecurityClient;
import org.elasticsearch.xpack.security.rest.action.SecurityBaseRestHandler;

public class RestPutUserAction
extends SecurityBaseRestHandler
implements RestRequestFilter {
    private final Hasher passwordHasher;
    private static final Set<String> FILTERED_FIELDS = Collections.unmodifiableSet(Sets.newHashSet((Object[])new String[]{"password", "password_hash"}));

    public RestPutUserAction(Settings settings, XPackLicenseState licenseState) {
        super(settings, licenseState);
        this.passwordHasher = Hasher.resolve((String)((String)XPackSettings.PASSWORD_HASHING_ALGORITHM.get(settings)));
    }

    public List<RestHandler.Route> routes() {
        return org.elasticsearch.common.collect.List.of((Object)RestHandler.Route.builder((RestRequest.Method)RestRequest.Method.POST, (String)"/_security/user/{username}").replaces(RestRequest.Method.POST, "/_xpack/security/user/{username}", RestApiVersion.V_7).build(), (Object)RestHandler.Route.builder((RestRequest.Method)RestRequest.Method.PUT, (String)"/_security/user/{username}").replaces(RestRequest.Method.PUT, "/_xpack/security/user/{username}", RestApiVersion.V_7).build());
    }

    public String getName() {
        return "security_put_user_action";
    }

    @Override
    public BaseRestHandler.RestChannelConsumer innerPrepareRequest(final RestRequest request, NodeClient client) throws IOException {
        PutUserRequestBuilder requestBuilder = (PutUserRequestBuilder)new SecurityClient((ElasticsearchClient)client).preparePutUser(request.param("username"), request.requiredContent(), request.getXContentType(), this.passwordHasher).setRefreshPolicy(request.param("refresh"));
        return channel -> requestBuilder.execute((ActionListener)new RestBuilderListener<PutUserResponse>(channel){

            public RestResponse buildResponse(PutUserResponse putUserResponse, XContentBuilder builder) throws Exception {
                putUserResponse.toXContent(builder, (ToXContent.Params)request);
                return new BytesRestResponse(RestStatus.OK, builder);
            }
        });
    }

    public Set<String> getFilteredFields() {
        return FILTERED_FIELDS;
    }
}

