/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.security.rest.action.oauth2;

import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.ElasticsearchSecurityException;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.ActionRequestValidationException;
import org.elasticsearch.action.ActionType;
import org.elasticsearch.client.node.NodeClient;
import org.elasticsearch.common.ParseField;
import org.elasticsearch.common.RestApiVersion;
import org.elasticsearch.common.settings.SecureString;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.util.set.Sets;
import org.elasticsearch.common.xcontent.ConstructingObjectParser;
import org.elasticsearch.common.xcontent.ObjectParser;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.license.XPackLicenseState;
import org.elasticsearch.rest.BaseRestHandler;
import org.elasticsearch.rest.BytesRestResponse;
import org.elasticsearch.rest.RestChannel;
import org.elasticsearch.rest.RestHandler;
import org.elasticsearch.rest.RestRequest;
import org.elasticsearch.rest.RestRequestFilter;
import org.elasticsearch.rest.RestResponse;
import org.elasticsearch.rest.RestStatus;
import org.elasticsearch.xpack.core.security.action.token.CreateTokenAction;
import org.elasticsearch.xpack.core.security.action.token.CreateTokenRequest;
import org.elasticsearch.xpack.core.security.action.token.CreateTokenResponse;
import org.elasticsearch.xpack.core.security.action.token.RefreshTokenAction;
import org.elasticsearch.xpack.security.rest.action.oauth2.TokenBaseRestHandler;

public final class RestGetTokenAction
extends TokenBaseRestHandler
implements RestRequestFilter {
    static final ConstructingObjectParser<CreateTokenRequest, Void> PARSER = new ConstructingObjectParser("token_request", a -> new CreateTokenRequest((String)a[0], (String)a[1], (SecureString)a[2], (SecureString)a[3], (String)a[4], (String)a[5]));
    private static final Set<String> FILTERED_FIELDS;

    public RestGetTokenAction(Settings settings, XPackLicenseState xPackLicenseState) {
        super(settings, xPackLicenseState);
    }

    public List<RestHandler.Route> routes() {
        return org.elasticsearch.common.collect.List.of((Object)RestHandler.Route.builder((RestRequest.Method)RestRequest.Method.POST, (String)"/_security/oauth2/token").replaces(RestRequest.Method.POST, "/_xpack/security/oauth2/token", RestApiVersion.V_7).build());
    }

    public String getName() {
        return "security_get_token_action";
    }

    @Override
    protected BaseRestHandler.RestChannelConsumer innerPrepareRequest(RestRequest request, NodeClient client) throws IOException {
        try (XContentParser parser = request.contentParser();){
            CreateTokenRequest tokenRequest = (CreateTokenRequest)PARSER.parse(parser, null);
            RefreshTokenAction action = "refresh_token".equals(tokenRequest.getGrantType()) ? RefreshTokenAction.INSTANCE : CreateTokenAction.INSTANCE;
            BaseRestHandler.RestChannelConsumer restChannelConsumer = arg_0 -> this.lambda$innerPrepareRequest$3(client, (ActionType)action, tokenRequest, request, arg_0);
            return restChannelConsumer;
        }
    }

    public Set<String> getFilteredFields() {
        return FILTERED_FIELDS;
    }

    private /* synthetic */ void lambda$innerPrepareRequest$3(NodeClient client, ActionType action, CreateTokenRequest tokenRequest, RestRequest request, RestChannel channel) throws Exception {
        client.execute(action, (ActionRequest)tokenRequest, (ActionListener)new CreateTokenResponseActionListener(channel, request, this.logger));
    }

    static {
        PARSER.declareString(ConstructingObjectParser.optionalConstructorArg(), new ParseField("grant_type", new String[0]));
        PARSER.declareString(ConstructingObjectParser.optionalConstructorArg(), new ParseField("username", new String[0]));
        PARSER.declareField(ConstructingObjectParser.optionalConstructorArg(), parser -> new SecureString(Arrays.copyOfRange(parser.textCharacters(), parser.textOffset(), parser.textOffset() + parser.textLength())), new ParseField("password", new String[0]), ObjectParser.ValueType.STRING);
        PARSER.declareField(ConstructingObjectParser.optionalConstructorArg(), parser -> new SecureString(Arrays.copyOfRange(parser.textCharacters(), parser.textOffset(), parser.textOffset() + parser.textLength())), new ParseField("kerberos_ticket", new String[0]), ObjectParser.ValueType.STRING);
        PARSER.declareString(ConstructingObjectParser.optionalConstructorArg(), new ParseField("scope", new String[0]));
        PARSER.declareString(ConstructingObjectParser.optionalConstructorArg(), new ParseField("refresh_token", new String[0]));
        FILTERED_FIELDS = Collections.unmodifiableSet(Sets.newHashSet((Object[])new String[]{"password", "kerberos_ticket", "refresh_token"}));
    }

    static class CreateTokenResponseActionListener
    implements ActionListener<CreateTokenResponse> {
        private final RestChannel channel;
        private final RestRequest request;
        private final Logger logger;

        CreateTokenResponseActionListener(RestChannel restChannel, RestRequest restRequest, Logger logger) {
            this.channel = restChannel;
            this.request = restRequest;
            this.logger = logger;
        }

        public void onResponse(CreateTokenResponse createTokenResponse) {
            try (XContentBuilder builder = this.channel.newBuilder();){
                this.channel.sendResponse((RestResponse)new BytesRestResponse(RestStatus.OK, createTokenResponse.toXContent(builder, (ToXContent.Params)this.request)));
            }
            catch (IOException e) {
                this.onFailure(e);
            }
        }

        public void onFailure(Exception e) {
            this.logger.debug("Failed to create token", (Throwable)e);
            if (e instanceof ActionRequestValidationException) {
                ActionRequestValidationException validationException = (ActionRequestValidationException)e;
                TokenRequestError error = validationException.validationErrors().stream().anyMatch(s -> s.contains("grant_type")) ? TokenRequestError.UNSUPPORTED_GRANT_TYPE : TokenRequestError.INVALID_REQUEST;
                this.sendTokenErrorResponse(error, validationException.getMessage(), e);
            } else if (e instanceof ElasticsearchSecurityException && "invalid_grant".equals(e.getMessage()) && ((ElasticsearchSecurityException)((Object)e)).getHeader("error_description").size() == 1) {
                this.sendTokenErrorResponse(TokenRequestError.INVALID_GRANT, (String)((ElasticsearchSecurityException)((Object)e)).getHeader("error_description").get(0), e);
            } else if (e instanceof ElasticsearchSecurityException && "failed to authenticate user, gss context negotiation not complete".equals(e.getMessage())) {
                this.sendTokenErrorResponse(TokenRequestError._UNAUTHORIZED, this.extractBase64EncodedToken((ElasticsearchSecurityException)((Object)e)), e);
            } else {
                this.sendFailure(e);
            }
        }

        private String extractBase64EncodedToken(ElasticsearchSecurityException e) {
            String wwwAuthenticateHeaderValue;
            String base64EncodedToken = null;
            List values = e.getHeader("WWW-Authenticate");
            if (values != null && values.size() == 1 && (wwwAuthenticateHeaderValue = (String)values.get(0)).startsWith("Negotiate ")) {
                base64EncodedToken = wwwAuthenticateHeaderValue.substring("Negotiate ".length()).trim();
            }
            return base64EncodedToken;
        }

        void sendTokenErrorResponse(TokenRequestError error, String description, Exception e) {
            try (XContentBuilder builder = this.channel.newErrorBuilder();){
                builder.startObject().field("error", error.toString().toLowerCase(Locale.ROOT)).field("error_description", description).endObject();
                this.channel.sendResponse((RestResponse)new BytesRestResponse(RestStatus.BAD_REQUEST, builder));
            }
            catch (IOException ioe) {
                ioe.addSuppressed(e);
                this.sendFailure(e);
            }
        }

        void sendFailure(Exception e) {
            try {
                this.channel.sendResponse((RestResponse)new BytesRestResponse(this.channel, e));
            }
            catch (Exception inner) {
                inner.addSuppressed(e);
                this.logger.error("failed to send failure response", (Throwable)inner);
            }
        }
    }

    static enum TokenRequestError {
        INVALID_REQUEST,
        INVALID_CLIENT,
        INVALID_GRANT,
        UNAUTHORIZED_CLIENT,
        UNSUPPORTED_GRANT_TYPE,
        INVALID_SCOPE,
        _UNAUTHORIZED;

    }
}

