/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.security.authc.service;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.function.Function;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.message.Message;
import org.apache.logging.log4j.message.ParameterizedMessage;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.common.util.concurrent.ThreadContext;
import org.elasticsearch.xpack.core.common.IteratingActionListener;
import org.elasticsearch.xpack.core.security.action.service.TokenInfo;
import org.elasticsearch.xpack.security.authc.service.ServiceAccount;
import org.elasticsearch.xpack.security.authc.service.ServiceAccountToken;
import org.elasticsearch.xpack.security.authc.service.ServiceAccountTokenStore;

public final class CompositeServiceAccountTokenStore
implements ServiceAccountTokenStore {
    private static final Logger logger = LogManager.getLogger(CompositeServiceAccountTokenStore.class);
    private final ThreadContext threadContext;
    private final List<ServiceAccountTokenStore> stores;

    public CompositeServiceAccountTokenStore(List<ServiceAccountTokenStore> stores, ThreadContext threadContext) {
        this.stores = stores;
        this.threadContext = threadContext;
    }

    @Override
    public void authenticate(ServiceAccountToken token, ActionListener<Boolean> listener) {
        IteratingActionListener authenticatingListener = new IteratingActionListener(listener, (store, successListener) -> store.authenticate(token, (ActionListener<Boolean>)successListener), this.stores, this.threadContext, Function.identity(), success -> Boolean.FALSE == success);
        try {
            authenticatingListener.run();
        }
        catch (Exception e) {
            logger.debug((Message)new ParameterizedMessage("authentication of service token [{}] failed", (Object)token.getQualifiedName()), (Throwable)e);
            listener.onFailure(e);
        }
    }

    @Override
    public void findTokensFor(ServiceAccount.ServiceAccountId accountId, ActionListener<Collection<TokenInfo>> listener) {
        CollectingActionListener collector = new CollectingActionListener(accountId, listener);
        try {
            collector.run();
        }
        catch (Exception e) {
            listener.onFailure(e);
        }
    }

    class CollectingActionListener
    implements ActionListener<Collection<TokenInfo>>,
    Runnable {
        private final ActionListener<Collection<TokenInfo>> delegate;
        private final ServiceAccount.ServiceAccountId accountId;
        private final List<TokenInfo> result = new ArrayList<TokenInfo>();
        private int position = 0;

        CollectingActionListener(ServiceAccount.ServiceAccountId accountId, ActionListener<Collection<TokenInfo>> delegate) {
            this.delegate = delegate;
            this.accountId = accountId;
        }

        @Override
        public void run() {
            if (CompositeServiceAccountTokenStore.this.stores.isEmpty()) {
                this.delegate.onResponse((Object)org.elasticsearch.common.collect.List.of());
            } else if (this.position < 0 || this.position >= CompositeServiceAccountTokenStore.this.stores.size()) {
                this.onFailure(new IllegalArgumentException("invalid position [" + this.position + "]. List size [" + CompositeServiceAccountTokenStore.this.stores.size() + "]"));
            } else {
                ((ServiceAccountTokenStore)CompositeServiceAccountTokenStore.this.stores.get(this.position++)).findTokensFor(this.accountId, this);
            }
        }

        public void onResponse(Collection<TokenInfo> response) {
            this.result.addAll(response);
            if (this.position == CompositeServiceAccountTokenStore.this.stores.size()) {
                this.delegate.onResponse((Object)org.elasticsearch.common.collect.List.copyOf(this.result));
            } else {
                ((ServiceAccountTokenStore)CompositeServiceAccountTokenStore.this.stores.get(this.position++)).findTokensFor(this.accountId, this);
            }
        }

        public void onFailure(Exception e) {
            this.delegate.onFailure(e);
        }
    }
}

