/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.http.netty4;

import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.http.HttpContent;
import io.netty.handler.codec.http.LastHttpContent;
import io.netty.util.concurrent.GenericFutureListener;
import java.util.ArrayList;
import java.util.List;
import org.elasticsearch.common.bytes.ReleasableBytesReference;
import org.elasticsearch.common.util.concurrent.ThreadContext;
import org.elasticsearch.core.Releasable;
import org.elasticsearch.core.Releasables;
import org.elasticsearch.http.HttpBody;
import org.elasticsearch.transport.netty4.Netty4Utils;

public class Netty4HttpRequestBodyStream
implements HttpBody.Stream {
    private final List<HttpBody.ChunkHandler> tracingHandlers = new ArrayList<HttpBody.ChunkHandler>(4);
    private final ThreadContext threadContext;
    private final ChannelHandlerContext ctx;
    private boolean closing = false;
    private boolean readLastChunk = false;
    private HttpBody.ChunkHandler handler;
    private ThreadContext.StoredContext requestContext;
    private final ChannelFutureListener closeListener = future -> this.doClose();

    public Netty4HttpRequestBodyStream(ChannelHandlerContext ctx, ThreadContext threadContext) {
        this.ctx = ctx;
        this.threadContext = threadContext;
        this.requestContext = threadContext.newStoredContext();
        Netty4Utils.addListener(ctx.channel().closeFuture(), this.closeListener);
    }

    public HttpBody.ChunkHandler handler() {
        return this.handler;
    }

    public void setHandler(HttpBody.ChunkHandler chunkHandler) {
        assert (this.ctx.channel().eventLoop().inEventLoop()) : Thread.currentThread().getName();
        this.handler = chunkHandler;
    }

    public void addTracingHandler(HttpBody.ChunkHandler chunkHandler) {
        assert (!this.tracingHandlers.contains(chunkHandler));
        this.tracingHandlers.add(chunkHandler);
    }

    private void read() {
        this.ctx.channel().eventLoop().execute(() -> ((ChannelHandlerContext)this.ctx).read());
    }

    public void next() {
        assert (this.handler != null) : "handler must be set before requesting next chunk";
        this.requestContext = this.threadContext.newStoredContext();
        this.read();
    }

    public void handleNettyContent(HttpContent httpContent) {
        assert (this.ctx.channel().eventLoop().inEventLoop()) : Thread.currentThread().getName();
        assert (!this.readLastChunk);
        if (this.closing) {
            httpContent.release();
            this.read();
        } else {
            try (ThreadContext.StoredContext ignored = this.threadContext.restoreExistingContext(this.requestContext);){
                boolean isLast = httpContent instanceof LastHttpContent;
                ReleasableBytesReference buf = Netty4Utils.toReleasableBytesReference(httpContent.content());
                for (HttpBody.ChunkHandler tracer : this.tracingHandlers) {
                    tracer.onNext(buf, isLast);
                }
                this.handler.onNext(buf, isLast);
                if (isLast) {
                    this.readLastChunk = true;
                    this.ctx.channel().closeFuture().removeListener((GenericFutureListener)this.closeListener);
                    this.read();
                }
            }
        }
    }

    public void close() {
        if (this.ctx.channel().eventLoop().inEventLoop()) {
            this.doClose();
        } else {
            this.ctx.channel().eventLoop().submit(this::doClose);
        }
    }

    private void doClose() {
        assert (this.ctx.channel().eventLoop().inEventLoop()) : Thread.currentThread().getName();
        if (!this.closing) {
            this.closing = true;
            try (ThreadContext.StoredContext ignored = this.threadContext.restoreExistingContext(this.requestContext);){
                for (HttpBody.ChunkHandler tracer : this.tracingHandlers) {
                    Releasables.closeExpectNoException((Releasable)tracer);
                }
                if (this.handler != null) {
                    this.handler.close();
                }
            }
            if (!this.readLastChunk) {
                this.read();
            }
        }
    }
}

