/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.http.netty4;

import io.netty.channel.Channel;
import java.net.InetSocketAddress;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.core.CompletableContext;
import org.elasticsearch.http.HttpServerChannel;
import org.elasticsearch.transport.netty4.Netty4TcpChannel;

public class Netty4HttpServerChannel
implements HttpServerChannel {
    private final Channel channel;
    private final CompletableContext<Void> closeContext = new CompletableContext();

    Netty4HttpServerChannel(Channel channel) {
        this.channel = channel;
        Netty4TcpChannel.addListener(this.channel.closeFuture(), this.closeContext);
    }

    public InetSocketAddress getLocalAddress() {
        return (InetSocketAddress)this.channel.localAddress();
    }

    public void addCloseListener(ActionListener<Void> listener) {
        this.closeContext.addListener(ActionListener.toBiConsumer(listener));
    }

    public boolean isOpen() {
        return this.channel.isOpen();
    }

    public void close() {
        this.channel.close();
    }

    public String toString() {
        return "Netty4HttpChannel{localAddress=" + this.getLocalAddress() + "}";
    }
}

