/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.http.netty4;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.CompositeByteBuf;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFutureListener;
import io.netty.handler.codec.http.HttpContent;
import io.netty.handler.codec.http.LastHttpContent;
import io.netty.util.concurrent.GenericFutureListener;
import java.util.ArrayList;
import java.util.List;
import org.elasticsearch.common.bytes.ReleasableBytesReference;
import org.elasticsearch.core.Releasable;
import org.elasticsearch.core.Releasables;
import org.elasticsearch.http.HttpBody;
import org.elasticsearch.transport.netty4.Netty4Utils;

public class Netty4HttpRequestBodyStream
implements HttpBody.Stream {
    private final Channel channel;
    private final ChannelFutureListener closeListener = future -> this.doClose();
    private final List<HttpBody.ChunkHandler> tracingHandlers = new ArrayList<HttpBody.ChunkHandler>(4);
    private ByteBuf buf;
    private boolean requested = false;
    private boolean closing = false;
    private HttpBody.ChunkHandler handler;
    private volatile int bufSize = 0;
    private volatile boolean hasLast = false;

    public Netty4HttpRequestBodyStream(Channel channel) {
        this.channel = channel;
        Netty4Utils.addListener(channel.closeFuture(), this.closeListener);
        channel.config().setAutoRead(false);
    }

    public HttpBody.ChunkHandler handler() {
        return this.handler;
    }

    public void setHandler(HttpBody.ChunkHandler chunkHandler) {
        this.handler = chunkHandler;
    }

    public void addTracingHandler(HttpBody.ChunkHandler chunkHandler) {
        assert (!this.tracingHandlers.contains(chunkHandler));
        this.tracingHandlers.add(chunkHandler);
    }

    public void next() {
        assert (!this.closing) : "cannot request next chunk on closing stream";
        assert (this.handler != null) : "handler must be set before requesting next chunk";
        this.channel.eventLoop().submit(() -> {
            this.requested = true;
            if (this.buf == null) {
                this.channel.read();
            } else {
                this.send();
            }
        });
    }

    public void handleNettyContent(HttpContent httpContent) {
        assert (!this.hasLast) : "receive http content on completed stream";
        this.hasLast = httpContent instanceof LastHttpContent;
        if (this.closing) {
            httpContent.release();
        } else {
            this.addChunk(httpContent.content());
            if (this.requested) {
                this.send();
            }
        }
        if (this.hasLast) {
            this.channel.config().setAutoRead(true);
            this.channel.closeFuture().removeListener((GenericFutureListener)this.closeListener);
        }
    }

    private void addChunk(ByteBuf chunk) {
        assert (chunk != null);
        if (this.buf == null) {
            this.buf = chunk;
        } else {
            ByteBuf byteBuf = this.buf;
            if (byteBuf instanceof CompositeByteBuf) {
                CompositeByteBuf comp = (CompositeByteBuf)byteBuf;
                comp.addComponent(true, chunk);
            } else {
                CompositeByteBuf comp = this.channel.alloc().compositeBuffer();
                comp.addComponent(true, this.buf);
                comp.addComponent(true, chunk);
                this.buf = comp;
            }
        }
        this.bufSize = this.buf.readableBytes();
    }

    Channel channel() {
        return this.channel;
    }

    int bufSize() {
        return this.bufSize;
    }

    boolean hasLast() {
        return this.hasLast;
    }

    private void send() {
        assert (this.requested);
        assert (this.handler != null) : "must set handler before receiving next chunk";
        ReleasableBytesReference bytesRef = Netty4Utils.toReleasableBytesReference(this.buf);
        this.requested = false;
        this.buf = null;
        this.bufSize = 0;
        for (HttpBody.ChunkHandler tracer : this.tracingHandlers) {
            tracer.onNext(bytesRef, this.hasLast);
        }
        this.handler.onNext(bytesRef, this.hasLast);
    }

    public void close() {
        if (this.channel.eventLoop().inEventLoop()) {
            this.doClose();
        } else {
            this.channel.eventLoop().submit(this::doClose);
        }
    }

    private void doClose() {
        this.closing = true;
        for (HttpBody.ChunkHandler tracer : this.tracingHandlers) {
            Releasables.closeExpectNoException((Releasable)tracer);
        }
        if (this.handler != null) {
            this.handler.close();
        }
        if (this.buf != null) {
            this.buf.release();
            this.buf = null;
            this.bufSize = 0;
        }
        this.channel.config().setAutoRead(true);
    }
}

