/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.transport.netty4;

import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.ExceptionsHelper;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.bytes.ReleasableBytesReference;
import org.elasticsearch.common.util.concurrent.ThreadContext;
import org.elasticsearch.core.RefCounted;
import org.elasticsearch.core.Releasable;
import org.elasticsearch.core.Releasables;
import org.elasticsearch.transport.InboundPipeline;
import org.elasticsearch.transport.TcpChannel;
import org.elasticsearch.transport.Transports;
import org.elasticsearch.transport.netty4.Netty4TcpChannel;
import org.elasticsearch.transport.netty4.Netty4Transport;
import org.elasticsearch.transport.netty4.Netty4Utils;

public class Netty4MessageInboundHandler
extends ChannelInboundHandlerAdapter {
    private final Netty4Transport transport;
    private final InboundPipeline pipeline;

    public Netty4MessageInboundHandler(Netty4Transport transport, InboundPipeline inboundPipeline) {
        this.transport = transport;
        this.pipeline = inboundPipeline;
    }

    public void channelRead(ChannelHandlerContext ctx, Object msg) throws Exception {
        assert (Transports.assertDefaultThreadContext((ThreadContext)this.transport.getThreadPool().getThreadContext()));
        assert (Transports.assertTransportThread());
        assert (msg instanceof ByteBuf) : "Expected message type ByteBuf, found: " + msg.getClass();
        ByteBuf buffer = (ByteBuf)msg;
        Netty4TcpChannel channel = (Netty4TcpChannel)ctx.channel().attr(Netty4Transport.CHANNEL_KEY).get();
        BytesReference wrapped = Netty4Utils.toBytesReference(buffer);
        try (ReleasableBytesReference reference = new ReleasableBytesReference(wrapped, (RefCounted)new ByteBufRefCounted(buffer));){
            this.pipeline.handleBytes((TcpChannel)channel, reference);
        }
    }

    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) {
        assert (Transports.assertDefaultThreadContext((ThreadContext)this.transport.getThreadPool().getThreadContext()));
        ExceptionsHelper.maybeDieOnAnotherThread((Throwable)cause);
        Throwable unwrapped = ExceptionsHelper.unwrap((Throwable)cause, (Class[])new Class[]{ElasticsearchException.class});
        Throwable newCause = unwrapped != null ? unwrapped : cause;
        Netty4TcpChannel tcpChannel = (Netty4TcpChannel)ctx.channel().attr(Netty4Transport.CHANNEL_KEY).get();
        if (newCause instanceof Error) {
            this.transport.onException(tcpChannel, new Exception(newCause));
        } else {
            this.transport.onException(tcpChannel, (Exception)newCause);
        }
    }

    public void channelInactive(ChannelHandlerContext ctx) throws Exception {
        Releasables.closeExpectNoException((Releasable)this.pipeline);
        super.channelInactive(ctx);
    }

    private record ByteBufRefCounted(ByteBuf buffer) implements RefCounted
    {
        public void incRef() {
            this.buffer.retain();
        }

        public boolean tryIncRef() {
            if (!this.hasReferences()) {
                return false;
            }
            try {
                this.buffer.retain();
            }
            catch (RuntimeException e) {
                assert (!this.hasReferences());
                return false;
            }
            return true;
        }

        public boolean decRef() {
            return this.buffer.release();
        }

        public boolean hasReferences() {
            return this.buffer.refCnt() > 0;
        }
    }
}

